﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Web;
using System.Net;
using Sgml;
using System.Xml;
using System.IO;

namespace AmazonHotDeal
{
    class category
    {
        public struct categoryItem
        {
            public string Name{ get; set; }
            public string Url { get; set; }
            public List<categoryItem> subCategoryList;
        };

        List<categoryItem> mainCategoryList;
        crifanLib crifanLib;


        XmlDocument htmlToXmlDoc(string html)
        {
            // setup SgmlReader
            Sgml.SgmlReader sgmlReader = new Sgml.SgmlReader();
            sgmlReader.DocType = "HTML";
            sgmlReader.WhitespaceHandling = WhitespaceHandling.All;
            sgmlReader.CaseFolding = Sgml.CaseFolding.ToLower;
            //sgmlReader.InputStream = reader;
            sgmlReader.InputStream = new StringReader(html);

            // create document
            XmlDocument doc = new XmlDocument();
            doc.PreserveWhitespace = true;
            doc.XmlResolver = null;
            doc.Load(sgmlReader);

            return doc;
        }

        void initSingleMainCategory(XmlNode mainCategoryNode)
        {
            //init value for current main category
            categoryItem mainCategory = new categoryItem();
            List<categoryItem> subCategoryList = new List<categoryItem>();
            //<li><a href='http://www.amazon.com/gp/new-releases/appliances/ref=zg_bsnr_nav_0'>Appliances</a></li>
            mainCategory.Name = mainCategoryNode.InnerText;
            mainCategory.Url = mainCategoryNode.Attributes["href"].Value;
            mainCategory.subCategoryList = subCategoryList;

            //find all sub category
            string subCategoryUrl = mainCategory.Url;
            string subCategoryHtml = crifanLib.getUrlRespHtml(subCategoryUrl);
            string decodedHtml = HttpUtility.HtmlDecode(subCategoryHtml);
            XmlDocument xmlDoc = htmlToXmlDoc(decodedHtml);
            //<span class="zg_selected"> Appliances</span>
            //XmlNode zgSelected = xmlDoc.SelectSingleNode("//span[@class='zg_selected']");

            //<div id="zg_left_col2">
            XmlNode zgLeftCol2 = xmlDoc.SelectSingleNode("//div[@id='zg_left_col2']");

            //<li><a href='http://www.amazon.com/gp/new-releases/appliances/3741261/ref=zg_bsnr_nav_la_1_la'>Cooktops</a></li>
            XmlNodeList subCategoryNodeList = zgLeftCol2.SelectNodes(".//li/a[@href]");
            //remove first one:
            //<a href="http://www.amazon.com/gp/new-releases/ref=zg_bsnr_unv_la_0_la_1">Any Category</a>
            //foreach (XmlNode singleSubCateoryNode in subCategoryNodeList)
            for (int index = 1; index < subCategoryNodeList.Count; index++)
            {
                XmlNode singleSubCateoryNode = subCategoryNodeList[index];
                categoryItem singleSubCat = new categoryItem();
                singleSubCat.Name = singleSubCateoryNode.InnerText;
                singleSubCat.Url = singleSubCateoryNode.Attributes["href"].Value;
                subCategoryList.Add(singleSubCat);
            }

            //in end, add to global list
            mainCategoryList.Add(mainCategory);
        }

        void initCategoryList_dynamic()
        {
            mainCategoryList = new List<categoryItem>();


            string amazonNewReleasesUrl = "http://www.amazon.com/gp/new-releases/ref=zg_bs_tab";
            string newRealeasesHtml = crifanLib.getUrlRespHtml(amazonNewReleasesUrl);
            string decodedHtml = HttpUtility.HtmlDecode(newRealeasesHtml);

            XmlDocument xmlDoc = htmlToXmlDoc(decodedHtml);
            //<div id="zg_left_col2">
            XmlNode zgLeftCol2 = xmlDoc.SelectSingleNode("//div[@id='zg_left_col2']");
            //<li><a href='http://www.amazon.com/gp/new-releases/appliances/ref=zg_bsnr_nav_0'>Appliances</a></li>
            XmlNodeList categoryNodeList = zgLeftCol2.SelectNodes(".//li/a[@href]");
            foreach (XmlNode singleMainCateoryNode in categoryNodeList)
            {
                initSingleMainCategory(singleMainCateoryNode);
            }
        }
        
        void initCategoryList_static()
        {
            mainCategoryList = new List<categoryItem>();

            categoryItem mainCategory;
            List<categoryItem> subCategoryList;
            categoryItem singleSubCat;


            //      <li><a href='(http.+)'>(['&;,\-\w\s]+)</a></li>(\r\n\r\n\r\n\r\n)?
            //singleSubCat\.Name = "\2";\r\nsingleSubCat\.Url = "\1";\r\nsubCategoryList.Add\(singleSubCat\);\r\n

            //Appliances
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Appliances";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/appliances/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Cooktops";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741261/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Dishwashers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741271/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Freezers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741331/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Ice Makers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/2399939011/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Range Hoods";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741441/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Ranges";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741411/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Refrigerators";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741361/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wall Ovens";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741481/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Warming Drawers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/2399955011/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Washers & Dryers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/2383576011/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wine Cellars";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/3741521/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Appliance Warranties";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/appliances/2242350011/ref=zg_bsnr_nav_la_1_la";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Appstore for Android
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Appstore for Android";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Books & Comics";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478833011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "City Info";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478840011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Communication";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478839011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cooking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478841011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Education";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478842011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Entertainment";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478843011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Finance";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478832011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Games";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478844011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Health & Fitness";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478845011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kids'";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478846011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Lifestyle";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478847011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Music";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478849011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Navigation";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478855011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "News & Magazines";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/3310778011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Novelty";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478858011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Photography";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478860011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Podcasts";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2577638011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Productivity";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478859011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Real Estate";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478861011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Reference";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478862011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Ringtones";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478863011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Shopping";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478864011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Social Networking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478865011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478866011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Themes";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478867011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Travel";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478868011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Utilities";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478869011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Weather";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/3310683011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Web Browsers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/mobile-apps/2478875011/ref=zg_bsnr_nav_mas_1_mas";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Arts, Crafts & Sewing
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Arts, Crafts & Sewing";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Beading & Jewelry Making";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12896081/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cases & Transport";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12896361/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Craft Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/378733011/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Drawing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12896641/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fabric";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12899121/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fabric Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/262680011/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fabric Painting & Dyeing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12896841/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Furniture & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12897011/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Knitting & Crochet";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12897221/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Needlework";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/2237329011/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Organization & Storage";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/2237594011/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Painting";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12897411/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Photography";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12898411/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Printmaking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12898451/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Safety & Cleaning";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12898721/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Scrapbooking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12898821/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sewing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12899091/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Thread";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/12897331/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Yarn";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/arts-crafts/262625011/ref=zg_bsnr_nav_ac_1_ac";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);

            //Automotive
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Automotive";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/automotive/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Car Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15718271/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Exterior Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15857511/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Interior Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15857501/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Motorcycle & ATV";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/346333011/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Oils & Fluids";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15718791/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Paint, Body & Trim";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15709231/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Performance Parts & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15710351/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Replacement Parts";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15719731/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "RV Parts & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/2258019011/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Tools & Equipment";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15706941/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wheels & Tires";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/automotive/15706571/ref=zg_bsnr_nav_auto_1_auto";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Baby
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Baby";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/baby-products/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Bathing & Skin Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166736011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Nursery Bedding";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166742011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Car Seats";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166835011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Diapering";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166764011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Feeding";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166777011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "For Moms";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166804011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Nursery Furniture";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166809011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Gear";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166828011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Gifts";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/239226011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Health & Baby Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166856011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Nursery Décor";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166875011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Potty Training";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166887011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Safety";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166863011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Strollers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/baby-products/166842011/ref=zg_bsnr_nav_ba_1_ba";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Books
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Books";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/books/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Arts & Photography";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/1/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Audible Audiobooks";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/2402172011/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bargain Books";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/45/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Biographies & Memoirs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/2/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Books on CD";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/69724/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Business & Investing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/3/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Calendars";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/67240/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Children's Books";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/4/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Christian Books & Bibles";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/12290/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Comics & Graphic Novels";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/4366/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Computers & Technology";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/5/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cookbooks, Food & Wine";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/6/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Crafts, Hobbies & Home";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/48/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Education & Reference";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/21/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Gay & Lesbian";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/301889/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Health, Fitness & Dieting";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/10/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "History";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/9/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Humor & Entertainment";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/86/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Large Print";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/300950/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Law";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/10777/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Libros en español";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/301731/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Literature & Fiction";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/17/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Medical Books";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/173514/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Mystery, Thriller & Suspense";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/18/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Parenting & Relationships";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/20/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Politics & Social Sciences";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/3377866011/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Professional & Technical";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/173507/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Religion & Spirituality";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/22/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Romance";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/23/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Science & Math";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/75/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Science Fiction & Fantasy";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/25/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Self-Help";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/4736/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sports & Outdoors";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/26/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Teens";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/28/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Travel";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/books/27/ref=zg_bsnr_nav_b_1_b";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Camera & Photo
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Camera & Photo";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/photo/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/172435/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Binoculars, Telescopes & Optics";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/499320/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Camcorders";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/172421/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cases & Bags";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/172437/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Digital Picture Frames";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/525460/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Digital SLRs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/3017941/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Lenses";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/499248/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Point-and-Shoot Digital Cameras";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/330405011/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Surveillance Cameras";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/photo/898400/ref=zg_bsnr_nav_p_1_p";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Cell Phones & Accessories
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Cell Phones & Accessories";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/wireless/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Cell Phones with Service";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/wireless/2407747011/ref=zg_bsnr_nav_cps_1_cps";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Prepaid Phones";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/wireless/2407748011/ref=zg_bsnr_nav_cps_1_cps";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Unlocked Phones";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/wireless/2407749011/ref=zg_bsnr_nav_cps_1_cps";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Mobile Broadband";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/wireless/2407750011/ref=zg_bsnr_nav_cps_1_cps";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/wireless/2407755011/ref=zg_bsnr_nav_cps_1_cps";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Clothing
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Clothing";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/apparel/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Women";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/1040660/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Men";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/1040658/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Girls";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/1040664/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Boys";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/1040666/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Baby";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/2402554011/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/1036700/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Novelty & Special Use";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/2227030011/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Luggage & Bags";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/apparel/15743161/ref=zg_bsnr_nav_a_1_a";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Computers & Accessories
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Computers & Accessories";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/pc/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Desktops";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pc/565098/ref=zg_bsnr_nav_pc_1_pc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Handhelds & PDAs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pc/172594/ref=zg_bsnr_nav_pc_1_pc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Notebooks";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pc/565108/ref=zg_bsnr_nav_pc_1_pc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Netbooks";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pc/1232596011/ref=zg_bsnr_nav_pc_1_pc";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Electronics
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Electronics";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/electronics/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Accessories & Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/281407/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Camera & Photo ";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/502394/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Car Electronics ";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/1077068/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Computers & Add-Ons";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/541966/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "GPS & Navigation";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/172526/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Home Audio & Theater ";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/667846011/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Marine Electronics";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/319574011/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Office Electronics";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/172574/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Portable Audio & Video";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/172623/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Security & Surveillance";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/524136/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Service & Replacement Plans";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/16285901/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Televisions & Video";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/1266092011/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Outlet";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/electronics/301793/ref=zg_bsnr_nav_e_1_e";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Grocery & Gourmet Food
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Grocery & Gourmet Food";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/grocery/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Produce";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/6506977011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Beans & Grains";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16321991/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Beverages";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16310231/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Breads & Bakery";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16318751/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Breakfast Foods";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16310251/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Candy";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16322431/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Chocolate";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16322461/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Condiments";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16319771/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cooking & Baking Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16310221/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Dairy & Eggs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/371460011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fresh Flowers & Live Indoor Plants";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/3745171/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Gourmet Gifts";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/2255571011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Herbs, Spices & Seasonings";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16310281/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Jams, Jellies & Spreads";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16320071/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Meat & Poultry";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/371469011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Noodles";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16322191/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Oils, Vinegars & Salad Dressings";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16320321/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pasta";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16322171/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Prepared Food";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16310241/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sauces & Dips";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16310271/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Seafood";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/371477011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Snack Food";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16322721/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Baby Food";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/16323111/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Home Brewing & Winemaking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/979861011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wine, Beer & Spirits";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/2983371011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pet Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/grocery/5037885011/ref=zg_bsnr_nav_gro_1_gro";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Health & Personal Care
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Health & Personal Care";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/hpc/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Baby & Child Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/10787321/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Health Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/3760941/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "House Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/15342811/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Medical Supplies & Equipment";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/3775161/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Nutrition & Wellness";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/3764441/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Personal Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/3777891/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sexual Wellness";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/3777371/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Manager's Special";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hpc/353413011/ref=zg_bsnr_nav_hpc_1_hpc";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Home & Kitchen
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Home & Kitchen";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/home-garden/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Kids' Home Store";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/3206325011/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kitchen & Dining";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/284507/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bedding";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/1063252/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bath";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/1063236/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Furniture";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/1063306/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Home Décor";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/1063278/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wall Décor";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/3736081/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Seasonal Décor";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/13679381/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Heating, Cooling & Air Quality";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/3206324011/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Irons & Steamers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/510240/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Vacuums & Floor Care";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/510106/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Storage & Organization";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/3610841/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cleaning Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/home-garden/10802561/ref=zg_bsnr_nav_hg_1_hg";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Home Improvement
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Home Improvement";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/hi/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Air Tools";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/552684/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Appliances";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/13397451/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Building Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/551240/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Contractor Supply";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/1259929011/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Electrical";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/495266/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Hardware";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/511228/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kitchen & Bath Fixtures";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/3754161/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Lamps & Light Fixtures";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/495224/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Painting Supplies & Wall Treatments";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/228899/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Power & Hand Tools";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/328182011/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Rough Plumbing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/13749581/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Safety & Security";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/3180231/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Storage & Home Organization";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/13400631/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Heavy Equipment & Agricultural Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/hi/2231046011/ref=zg_bsnr_nav_hi_1_hi";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Industrial & Scientific
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Industrial & Scientific";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/industrial/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Abrasive & Finishing Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/256167011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Additive Manufacturing Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/6066126011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cutting Tools";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/383598011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fasteners";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/383599011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Filtration";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/3061625011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Food Service Equipment & Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/6054382011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Hydraulics, Pneumatics & Plumbing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/3021479011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Industrial Electrical";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/306506011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Industrial Hardware";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/16412251/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Industrial Power & Hand Tools";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/3021459011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Janitorial & Sanitation Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/317971011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Lab & Scientific Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/317970011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Material Handling Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/256346011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Raw Materials";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/16310191/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Occupational Health & Safety Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/318135011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Power Transmission Products";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/16310181/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Science Education";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/393459011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Tapes, Adhesives & Sealants";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/256225011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Test, Measure & Inspect";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/industrial/256409011/ref=zg_bsnr_nav_indust_1_indust";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Jewelry
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Jewelry";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/jewelry/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3888431/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bracelets";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3885251/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Brooches & Pins";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3885491/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Charms";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3885701/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Children's Jewelry";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3880601/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Earrings";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3885911/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Engagement";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3890311/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Jewelry Sets";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3898891/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Men's Jewelry";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3887881/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Necklaces & Pendants";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3886281/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Religious Jewelry";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3893691/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Rings";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/3887251/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wedding & Anniversary";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/jewelry/16014541/ref=zg_bsnr_nav_jw_1_jw";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Kindle Store
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Kindle Store";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/digital-text/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Kindle Blogs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/241647011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kindle eBooks";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/154606011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kindle Magazines";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/241646011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kindle Newspapers";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/165389011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kindle Singles";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/2486013011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kindle Devices";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/2102313011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kindle Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/digital-text/370783011/ref=zg_bsnr_nav_kstore_1_kstore";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Kitchen & Dining
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Kitchen & Dining";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/kitchen/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Bakeware";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289668/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bar Tools & Glasses";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289728/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Coffee, Tea & Espresso Appliances";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289742/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cookware";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289814/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Glassware & Drinkware";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/13217501/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Home Brewing & Wine Making";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/979832011/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kitchen & Table Linens";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/1063916/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kitchen Knives & Cutlery Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289851/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kitchen Utensils & Gadgets";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289754/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Small Appliances";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/289913/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Storage & Organization";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/510136/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Tabletop";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/13162311/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wine Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/kitchen/13299291/ref=zg_bsnr_nav_k_1_k";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //MP3 Downloads
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "MP3 Downloads";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/dmusic/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "MP3 Albums";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/dmusic/digital-music-album/ref=zg_bsnr_nav_dmusic_1_dmusic";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "MP3 Songs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/dmusic/digital-music-track/ref=zg_bsnr_nav_dmusic_1_dmusic";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Movies & TV
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Movies & TV";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/movies-tv/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Amazon Instant Video";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/movies-tv/2958933011/ref=zg_bsnr_nav_mov_1_mov";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Blu-ray";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/movies-tv/2958935011/ref=zg_bsnr_nav_mov_1_mov";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "DVD";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/movies-tv/2958934011/ref=zg_bsnr_nav_mov_1_mov";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Music
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Music";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/music/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Alternative Rock";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/30/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Blues";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/31/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Box Sets";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/291920/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Broadway & Vocalists";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/265640/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Children's Music";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/173425/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Christian";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/173429/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Classic Rock";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/67204/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Classical";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/85/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Country";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/16/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Dance & DJ";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/7/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Folk";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/32/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Gospel";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/2231705011/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Hard Rock & Metal";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/67207/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Imports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/701208/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Indie Music";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/266023/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Jazz";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/34/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Latin Music";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/289122/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Miscellaneous";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/35/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "New Age";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/36/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Opera & Vocal";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/84/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pop";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/37/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "R&B";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/39/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Rap & Hip-Hop";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/38/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Rock";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/40/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Soundtracks";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/42/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "World Music";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/music/33/ref=zg_bsnr_nav_m_1_m";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Musical Instruments
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Musical Instruments";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Instrument Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11965871/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Guitars";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11971241/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bass Guitars";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11971311/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Drums & Percussion";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11970241/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Keyboards";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11969981/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Recording Equipment";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11973111/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Live Sound & Stage";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/405757011/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "DJ, Electronic Music & Karaoke";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11973881/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Band & Orchestra";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/405758011/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Folk & World Instruments";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/musical-instruments/11972411/ref=zg_bsnr_nav_MI_1_MI";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Office Products
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Office Products";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/office-products/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Business Presentation Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/1069254/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Educational Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/12899801/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Mailroom Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/1068972/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Office Electronics";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/172574/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Office Furniture & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/1069102/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Office Lighting";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/1068956/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Office Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/office-products/1069242/ref=zg_bsnr_nav_op_1_op";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Patio, Lawn & Garden
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Patio, Lawn & Garden";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Backyard Birding & Wildlife";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/553632/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Gardening";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/3610851/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Generators & Portable Power";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/552808/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Grills & Outdoor Cooking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/553760/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Mowers & Outdoor Power Tools";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/551242/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Outdoor Décor";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/553788/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Outdoor Heaters & Fire Pits";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/14107611/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Outdoor Storage";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/13400641/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Patio Furniture & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/553824/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pest Control";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/553844/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pools, Hot Tubs & Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/1272941011/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Snow Removal";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/lawn-garden/3043471/ref=zg_bsnr_nav_lg_1_lg";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Pet Supplies
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Pet Supplies";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Birds";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975221011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Cats";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975241011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Dogs";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975312011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fish & Aquatic Pets";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975446011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Horses";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975481011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Insects";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975497011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Reptiles & Amphibians";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975504011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Small Animals";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/pet-supplies/2975520011/ref=zg_bsnr_nav_petsupplies_1_petsupplies";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Shoes
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Shoes";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/shoes/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Women's";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/shoes/679337011/ref=zg_bsnr_nav_shoe_1_shoe";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Men's";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/shoes/679255011/ref=zg_bsnr_nav_shoe_1_shoe";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Girls'";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/shoes/679217011/ref=zg_bsnr_nav_shoe_1_shoe";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Boys'";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/shoes/679182011/ref=zg_bsnr_nav_shoe_1_shoe";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Software
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Software";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/software/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Business & Office";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229535/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Children's Software";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229548/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Computer Security";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229677/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Education & Reference";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229563/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Games";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/1294826011/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Graphics";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229614/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Home & Hobbies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229624/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Language & Travel";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/497026/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Networking";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229637/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Operating Systems";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229653/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Outlet";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/300228/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Personal Finance";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229540/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Programming";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229667/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Tax Preparation";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229545/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Utilities";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229672/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Video & Music";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/497022/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Web Development";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/497024/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "The Mac Software Store";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/software/229643/ref=zg_bsnr_nav_sw_1_sw";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Sports & Outdoors
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Sports & Outdoors";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Action Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706812011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bikes & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3403201/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Boating & Water Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3421331/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Equestrian Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3407321/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Exercise & Fitness";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3407731/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Golf";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3410851/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Hunting & Fishing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706813011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Leisure Sports & Games";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706808011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Other Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706810011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Outdoor Recreation";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706814011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Paintball & Airsoft";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706815011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Racket Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706816011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Snow Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/2204518011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Team Sports";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/706809011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3394801/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Clothing";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/2206626011/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fan Shop";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/sporting-goods/3386071/ref=zg_bsnr_nav_sg_1_sg";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Toys & Games
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Toys & Games";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Action & Toy Figures";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/165993011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Arts & Crafts";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166057011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Baby & Toddler Toys";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/196601011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Bikes, Skates & Ride-Ons";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/256994011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Building & Construction Toys";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166092011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Collectible Trading Cards & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166242011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Dolls & Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166118011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Dressing Up & Costumes";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166316011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Electronics for Kids";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166164011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Games";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166220011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Hobbies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/276729011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Kids' Furniture & Room Décor";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166210011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Learning & Education";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166269011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Musical Instruments";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166326011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Novelty & Gag Toys";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166027011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Party Supplies";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/1266203011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Play Vehicles";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166508011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Preschool";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/251909011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pretend Play";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166309011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Puppets & Puppet Theaters";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166333011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Puzzles";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166359011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sports & Outdoor Play";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166420011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Stuffed Animals & Toys";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/toys-and-games/166461011/ref=zg_bsnr_nav_t_1_t";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Video Games
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Video Games";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/videogames/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Xbox 360";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/14220161/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "PlayStation 3";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/14210751/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wii U";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/3075112011/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Wii";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/14218901/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "PlayStation Vita";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/3010556011/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Nintendo 3DS";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/2622269011/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Nintendo DS";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/11075831/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "PC Games";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/229575/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "PC Game Downloads";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/videogames/2445220011/ref=zg_bsnr_nav_vg_1_vg";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);


            //Watches
            mainCategory = new categoryItem();
            subCategoryList = new List<categoryItem>();
            mainCategory.Name = "Watches";
            mainCategory.Url = "http://www.amazon.com/gp/new-releases/watches/ref=zg_bsnr_nav_0";
            mainCategory.subCategoryList = subCategoryList;
            singleSubCat = new categoryItem();
            //begin add sub category
            singleSubCat.Name = "Collectible Watches";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/watches/378522011/ref=zg_bsnr_nav_watch_1_watch";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Fashion Watches";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/watches/378524011/ref=zg_bsnr_nav_watch_1_watch";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Pocket Watches";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/watches/378525011/ref=zg_bsnr_nav_watch_1_watch";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Sport Watches";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/watches/378526011/ref=zg_bsnr_nav_watch_1_watch";
            subCategoryList.Add(singleSubCat);
            singleSubCat.Name = "Accessories";
            singleSubCat.Url = "http://www.amazon.com/gp/new-releases/watches/378527011/ref=zg_bsnr_nav_watch_1_watch";
            subCategoryList.Add(singleSubCat);
            //add to list
            mainCategoryList.Add(mainCategory);

        }

        public category()
        {
            crifanLib = new crifanLib();

            //initCategoryList_dynamic();

            initCategoryList_static();
        }



        public List<categoryItem> getMainCategoryList()
        {
            return mainCategoryList;
        }
    }
}
