﻿/*
 * [File]
 * frmAuthorityCommentFinder.cs
 * 
 * [Function]
 * 1. emulate dropMyLink.com to do google search
 * 2. emulate chasethefootprint.com to do google search
 * 
 * [Author]
 * Crifan Li
 * 
 * [Date]
 * 2013-07-16
 * 
 * [Contact]
 * http://www.crifan.com/contact_me/
 */

#define DEBUG
//later calculate alexa rank and page rank
#define LATE_CALC_RANK

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Web;
using System.Net;

using HtmlAgilityPack;
using System.IO;

namespace AuthorityCommentFinder
{
    public partial class frmAuthorityCommentFinder : Form
    {
        public crifanLib crifanLib;
        public crifanLibGoogle google;

        //static int titleColumnIdx = 0;
        static int urlColumnIdx = 1;
        static int pageRankColumnIdx = 2;
        static int alexaRankColumnIdx = 3;

        public DataGridViewButtonColumn visitUrlColumn = null;
        public static int visitUrlColumnIdx = 4;

        //need continue search or not
        bool needContinueSearch = true;

        public const int invalidRankValue = -1;

        enum search_status
        {
            SEARCH_STATUS_STOPPED,
            SEARCH_STATUS_SEARCHING,
            //SEARCH_STATUS_PAUSED
        };
        search_status curSearchStatus = search_status.SEARCH_STATUS_STOPPED;
        //search_status curSearchStatus_footprint = search_status.SEARCH_STATUS_STOPPED;
        
        public frmAuthorityCommentFinder()
        {
            //!!! for load embedded dll: (1) register resovle handler
            AppDomain.CurrentDomain.AssemblyResolve += new ResolveEventHandler(CurrentDomain_AssemblyResolve);

            InitializeComponent();

            crifanLib = new crifanLib();
            google = new crifanLibGoogle();

            visitUrlColumn = new DataGridViewButtonColumn();
        }

        //!!! for load embedded dll: (2) implement this handler
        System.Reflection.Assembly CurrentDomain_AssemblyResolve(object sender, ResolveEventArgs args)
        {
            string dllName = args.Name.Contains(",") ? args.Name.Substring(0, args.Name.IndexOf(',')) : args.Name.Replace(".dll", "");

            dllName = dllName.Replace(".", "_");

            if (dllName.EndsWith("_resources")) return null;

            System.Resources.ResourceManager rm = new System.Resources.ResourceManager(GetType().Namespace + ".Properties.Resources", System.Reflection.Assembly.GetExecutingAssembly());

            byte[] bytes = (byte[])rm.GetObject(dllName);

            return System.Reflection.Assembly.Load(bytes);
        }

        void initSearchResultGridView()
        {
            dgvSearchResult.ColumnCount = 4;

            dgvSearchResult.RowHeadersWidth = 60;
            dgvSearchResult.RowHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
            dgvSearchResult.RowHeadersWidthSizeMode = DataGridViewRowHeadersWidthSizeMode.DisableResizing;

            //dgvSearchResult.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
            dgvSearchResult.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            dgvSearchResult.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.AllCellsExceptHeaders;

            //(1)title
            //dgvSearchedAlerts.Columns[0].AutoSizeMode = DataGridViewAutoSizeColumnMode.Fill;
            dgvSearchResult.Columns[0].HeaderText = "Title";
            dgvSearchResult.Columns[0].Width = 400;
            //(2)Url
            dgvSearchResult.Columns[1].HeaderText = "Url";
            dgvSearchResult.Columns[1].Width = 400;

            //(3)page rank of the domain
            //http://pagerank.webmasterhome.cn/
            //http://pr.chinaz.com/
            dgvSearchResult.Columns[2].HeaderText = "Page Rank";
            dgvSearchResult.Columns[2].Width = 100;

            //(4)alexa rank of the domain
            //http://moonsy.com/alexa_rank/
            //http://alexa.chinaz.com/
            dgvSearchResult.Columns[3].HeaderText = "Alexa Rank";
            dgvSearchResult.Columns[3].Width = 100;

            //(5)vist the page button
            // Add a button column
            visitUrlColumn.HeaderText = "View Page";
            //visitUrlColumn.Name = "Goto Url";
            visitUrlColumn.Text = "Visit Url";
            //visitUrlColumn.UseColumnTextForButtonValue = true;
            //visitUrlColumn.Width = 60;
            dgvSearchResult.Columns.Add(visitUrlColumn);
            visitUrlColumn.Width = 80;
        }

        private struct footprintPair
        {
            public string ShowString { get; set; } // for show
            public string EncodedAppend { get; set; } //for real appendded footprint
            public bool BAppendKeywordToEnd; //normall apped keyword to previous of footprint, some special apped to end
        }

        private struct keyValueList
        {
            public string Key{get;set;} // key
            //public List<string> ValueStrList{get;set;} // the string value list for the key
            public List<footprintPair> ValuePairList { get; set; } // the string value list for the key
        }

        List<keyValueList> gFootprintTypeSelList; // footprint type


        //http://chasethefootprint.com/
        private void initFootprintTypeAndFootprintString()
        {
            gFootprintTypeSelList = new List<keyValueList>();
            
            //init
            footprintPair footprintPair = new footprintPair();

            //1. option1: Guest Blogging
            keyValueList keyValueListGuestBlogging = new keyValueList();
            keyValueListGuestBlogging.Key = "Guest Blogging";
            //keyValueListGuestBlogging.ValueStrList = new List<string>();
            keyValueListGuestBlogging.ValuePairList = new List<footprintPair>();
            
            footprintPair.ShowString = "Guest Blogging";
            //"guest blogger" OR "guest post" OR "guest article" OR "Add Guest Post" OR "Submit Guest Post" OR "Submit a Guest Article" OR "Guest Post Guidelines"
            footprintPair.EncodedAppend = "%22guest%20blogger%22%20OR%20%22guest%20post%22%20OR%20%22guest%20article%22%20OR%20%22Add%20Guest%20Post%22%20OR%20%22Submit%20Guest%20Post%22%20OR%20%22Submit%20a%20Guest%20Article%22%20OR%20%22Guest%20Post%20Guidelines%22";
            keyValueListGuestBlogging.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Contribute";
            //"become a contributor" OR "contribute to this site" OR "Add Content"
            footprintPair.EncodedAppend = "%22become%20a%20contributor%22%20OR%20%22contribute%20to%20this%20site%22%20OR%20%22Add%20Content%22";
            keyValueListGuestBlogging.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Write for us";
            //""write for us" OR "write for me"" OR "submit your writing" OR "submit article"
            footprintPair.EncodedAppend = "%22%22write%20for%20us%22%20OR%20%22write%20for%20me%22%22%20OR%20%22submit%20your%20writing%22%20OR%20%22submit%20article%22";
            keyValueListGuestBlogging.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Guest Category";
            //"inurl:category/guest"
            footprintPair.EncodedAppend = "%22inurl%3Acategory/guest%22";
            keyValueListGuestBlogging.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Submit Content";
            //"submit content" OR "post content"
            footprintPair.EncodedAppend = "%22submit%20content%22%20OR%20%22post%20content%22";
            keyValueListGuestBlogging.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListGuestBlogging);

            //2. option2: Blog Commenting
            keyValueList keyValueListBlogCommenting = new keyValueList();
            keyValueListBlogCommenting.Key = "Blog Commenting";
            keyValueListBlogCommenting.ValuePairList = new List<footprintPair>();

            footprintPair.ShowString = "KeywordLuv Blogs";
            //"Enter YourName@YourKeywords"
            footprintPair.EncodedAppend = "%22Enter%20YourName@YourKeywords%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Joomla JComments Plugin";
            //"Powered by JComments"
            footprintPair.EncodedAppend = "%22Powered%20by%20JComments%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Yootheme Zoo Blog App";
            //"inurl:"option=com_zoo"
            footprintPair.EncodedAppend = "%22inurl%3A%22option%3Dcom_zoo%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "CommentLuv Premium Blogs";
            //"This blog uses premium CommentLuv" -"The version of CommentLuv on this site is no longer supported."
            footprintPair.EncodedAppend = "%22This%20blog%20uses%20premium%20CommentLuv%22%20-%22The%20version%20of%20CommentLuv%20on%20this%20site%20is%20no%20longer%20supported.%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Anchor Text In Comment Blogs";
            //"Allowed HTML tags:"
            footprintPair.EncodedAppend = "%22Allowed%20HTML%20tags%3A%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Do Follow Comment Blogs";
            //"Notify me of follow-up comments?" "Submit the word you see below"
            footprintPair.EncodedAppend = "%22Notify%20me%20of%20follow-up%20comments%3F%22+%22Submit%20the%20word%20you%20see%20below%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Create your own .GOV Wordpress site";
            //inurl:.gov inurl:wp-signup.php
            footprintPair.EncodedAppend = "inurl%3A.gov%20inurl%3Awp-signup.php";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Create your own .EDU Wordpress site";
            //inurl:.edu inurl:wp-signup.php
            footprintPair.EncodedAppend = "inurl%3A.edu%20inurl%3Awp-signup.php";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Find .edu Blogs";
            //site:.edu inurl:blog "post a comment" -"you must be logged in"
            footprintPair.EncodedAppend = "site%3A.edu%20inurl%3Ablog%20%22post%20a%20comment%22%20-%22you%20must%20be%20logged%20in%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Find .gov Blogs";
            //site:.gov inurl:blog "post a comment" -"you must be logged in"
            footprintPair.EncodedAppend = "site%3A.gov%20inurl%3Ablog%20%22post%20a%20comment%22%20-%22you%20must%20be%20logged%20in%22";
            keyValueListBlogCommenting.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListBlogCommenting);

            //3. option3: Message Boards and Forums
            keyValueList keyValueListMessageBoardsAndForums = new keyValueList();
            keyValueListMessageBoardsAndForums.Key = "Message Boards and Forums";
            keyValueListMessageBoardsAndForums.ValuePairList = new List<footprintPair>();
                        
            footprintPair.ShowString = "PHPbb";
            //"Powered by PHPbb"
            footprintPair.EncodedAppend = "%22Powered%20by%20PHPbb%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "vBulletin";
            //"Powered by vBulletin"
            footprintPair.EncodedAppend = "%22Powered%20by%20vBulletin%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "SMF";
            //"Powered by SMF"
            footprintPair.EncodedAppend = "%22Powered%20by%20SMF%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Simple Machines";
            //"powered by Simple Machines"
            footprintPair.EncodedAppend = "%22powered%20by%20Simple%20Machines%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "punBB";
            //"powered by punBB"
            footprintPair.EncodedAppend = "%22powered%20by%20punBB%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Expression Engine";
            //"powered by expressionengine"
            footprintPair.EncodedAppend = "%22powered%20by%20expressionengine%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Blog Engine";
            //"Powered by BlogEngine.NET" inurl:blog "post a comment" -"comments closed"
            footprintPair.EncodedAppend = "%22Powered%20by%20BlogEngine.NET%22%20inurl%3Ablog%20%22post%20a%20comment%22%20-%22comments%20closed%22";
            keyValueListMessageBoardsAndForums.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListMessageBoardsAndForums);

            //4. option4: Advanced Search Parameters

            //all this group append keyword to end
            footprintPair.BAppendKeywordToEnd = true;

            keyValueList keyValueListAdvancedSearchParameters = new keyValueList();
            keyValueListAdvancedSearchParameters.Key = "Advanced Search Parameters";
            keyValueListAdvancedSearchParameters.ValuePairList = new List<footprintPair>();

            
            footprintPair.ShowString = "URLs Containing Keyword";
            //"allinurl":
            //footprintPair.EncodedAppend = "%22allinurl%22%3A";
            //allinurl:
            footprintPair.EncodedAppend = "allinurl%3A";
            keyValueListAdvancedSearchParameters.ValuePairList.Add(footprintPair);
            
            footprintPair.ShowString = "Page Titles Containing Keyword";
            //allintitle:
            footprintPair.EncodedAppend = "allintitle%3A";
            keyValueListAdvancedSearchParameters.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Search Anchor Text";
            //allinanchor:
            footprintPair.EncodedAppend = "allinanchor%3A";
            keyValueListAdvancedSearchParameters.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Related (enter a domain)";
            //related:
            footprintPair.EncodedAppend = "related%3A";
            keyValueListAdvancedSearchParameters.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListAdvancedSearchParameters);

            //restore to normal
            footprintPair.BAppendKeywordToEnd = false;

            //5. option5: Sponsor/Donate
            keyValueList keyValueListSponsorDonate = new keyValueList();
            keyValueListSponsorDonate.Key = "Sponsor/Donate";
            keyValueListSponsorDonate.ValuePairList = new List<footprintPair>();

            footprintPair.ShowString = "Sponsor";
            //inurl:sponsors AND link
            footprintPair.EncodedAppend = "inurl%3Asponsors%20AND%20link";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Sponsorship";
            //"sponsorship"
            footprintPair.EncodedAppend = "%22sponsorship%22";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Benefactors";
            //"benefactors"
            footprintPair.EncodedAppend = "%22benefactors%22";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Sponsor Charity";
            //"sponsor charity"
            footprintPair.EncodedAppend = "%22sponsor%20charity%22";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Donate";
            //"donate"
            footprintPair.EncodedAppend = "%22donate%22";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Donations";
            //"donations"
            footprintPair.EncodedAppend = "%22donations%22";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Donors";
            //"donors"
            footprintPair.EncodedAppend = "%22donors%22";
            keyValueListSponsorDonate.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListSponsorDonate);

            //6. option6: Wiki / Media Wiki Pages
            keyValueList keyValueListWikiMediaWikiPages = new keyValueList();
            keyValueListWikiMediaWikiPages.Key = "Wiki / Media Wiki Pages";
            keyValueListWikiMediaWikiPages.ValuePairList = new List<footprintPair>();

            footprintPair.ShowString = "Wiki sites";
            //"inurl:wiki/index.php?title=" OR "inurl:mediawiki/index.php" OR "allinurl:http://mediawiki."
            footprintPair.EncodedAppend = "%22inurl%3Awiki/index.php%3Ftitle%3D%22%20OR%20%22inurl%3Amediawiki/index.php%22%20OR%20%22allinurl%3Ahttp%3A//mediawiki.%22";
            keyValueListWikiMediaWikiPages.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Outdated Wiki Content";
            //"This article is outdated"
            footprintPair.EncodedAppend = "%22This%20article%20is%20outdated%22";
            keyValueListWikiMediaWikiPages.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListWikiMediaWikiPages);

            //7. option7: Other Queries
            keyValueList keyValueListOtherQueries = new keyValueList();
            keyValueListOtherQueries.Key = "Other Queries";
            keyValueListOtherQueries.ValuePairList = new List<footprintPair>();

            footprintPair.ShowString = "Directory Add URL";
            //"dir-addurl"
            footprintPair.EncodedAppend = "%22dir-addurl%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Directory Site";
            //"dir-addsite"
            footprintPair.EncodedAppend = "%22dir-addsite%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Hubpages - Hot Hubs";
            //site:hubpages.com "hot hubs"
            footprintPair.EncodedAppend = "site%3Ahubpages.com%20%22hot%20hubs%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Squidoo lenses - Add To List";
            //"add to this list" site:squidoo.com
            footprintPair.EncodedAppend = "%22add+to+this+list%22%20site%3Asquidoo.com";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Social Bookmarking";
            //"Store, share and tag your favourite links"
            footprintPair.EncodedAppend = "%22Store%2C%20share%20and%20tag%20your%20favourite%20links%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Social Bookmarking 2.0";
            //"Bookmarking the web 2.0"
            footprintPair.EncodedAppend = "%22Bookmarking%20the%20web%202.0%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Guestbooks";
            //"intext:"Sign * Guestbook" intext:"back to guestbook" intext:"administration" intext:"Homepage""
            footprintPair.EncodedAppend = "%22intext%3A%22Sign%20*%20Guestbook%22%20intext%3A%22back%20to%20guestbook%22%20intext%3A%22administration%22%20intext%3A%22Homepage%22%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Suggest or Submit URL";
            //"Submit a link" OR "Submit a site" OR "Submit URL" OR "Submit an URL" OR "Suggest a link" OR "Suggest a site" OR "Suggest URL" OR "Suggest an URL"
            footprintPair.EncodedAppend = "%22Submit%20a%20link%22%20OR%20%22Submit%20a%20site%22%20OR%20%22Submit%20URL%22%20OR%20%22Submit%20an%20URL%22%20OR%20%22Suggest%20a%20link%22%20OR%20%22Suggest%20a%20site%22%20OR%20%22Suggest%20URL%22%20OR%20%22Suggest%20an%20URL%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Warp Framework (Joomla)";
            //"Powered by Warp Theme Framework"
            footprintPair.EncodedAppend = "%22Powered%20by%20Warp%20Theme%20Framework%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Angelae8654 Site Profiles";
            //"angelae8654"
            footprintPair.EncodedAppend = "%22angelae8654%22";
            keyValueListOtherQueries.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListOtherQueries);

            //8. option8: Link Bartering
            keyValueList keyValueListLinkBartering = new keyValueList();
            keyValueListLinkBartering.Key = "Link Bartering";
            keyValueListLinkBartering.ValuePairList = new List<footprintPair>();

            footprintPair.ShowString = "Buy Blog Posts";
            //"Buy Blog Posts" OR "Buy Blog Post" OR "Sponsor Blog Post"
            footprintPair.EncodedAppend = "%22Buy%20Blog%20Posts%22%20OR%20%22Buy%20Blog%20Post%22%20OR%20%22Sponsor%20Blog%20Post%22";
            keyValueListLinkBartering.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Buy Link";
            //"Buy Links" OR "Buy Bulk Links" OR "Purchase Links" OR "Advertise Here" OR "Sponsor Us" OR "Cheap Links"
            footprintPair.EncodedAppend = "%22Buy%20Links%22%20OR%20%22Buy%20Bulk%20Links%22%20OR%20%22Purchase%20Links%22%20OR%20%22Advertise%20Here%22%20OR%20%22Sponsor%20Us%22%20OR%20%22Cheap%20Links%22";
            keyValueListLinkBartering.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Link Exchange";
            //"Link Exchange" OR "Link Trade" OR "Link Ring" OR "Web Ring"
            footprintPair.EncodedAppend = "%22Link%20Exchange%22%20OR%20%22Link%20Trade%22%20OR%20%22Link%20Ring%22%20OR%20%22Web%20Ring%22";
            keyValueListLinkBartering.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Link Barter Service";
            //"Link Bartering Service" OR "Link Building service" OR "Cheap Links"
            footprintPair.EncodedAppend = "%22Link%20Bartering%20Service%22%20OR%20%22Link%20Building%20service%22%20OR%20%22Cheap%20Links%22";
            keyValueListLinkBartering.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListLinkBartering);

            //9. option9: Site Specific Sites
            keyValueList keyValueListSiteSpecificSites = new keyValueList();
            keyValueListSiteSpecificSites.Key = "Site Specific Sites";
            keyValueListSiteSpecificSites.ValuePairList = new List<footprintPair>();

            footprintPair.ShowString = "Facebook";
            //"site:facebook.com"
            footprintPair.EncodedAppend = "%22site%3Afacebook.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Twitter";
            //"site:twitter.com"
            footprintPair.EncodedAppend = "%22site%3Atwitter.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Pinterest";
            //"site:pinterest.com"
            footprintPair.EncodedAppend = "%22site%3Apinterest.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Google Groups";
            //"site:groups.google.com"
            footprintPair.EncodedAppend = "%22site%3Agroups.google.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Scribd";
            //"site:scribd.com"
            footprintPair.EncodedAppend = "%22site%3Ascribd.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Slideshare";
            //"site:slideshare.net"
            footprintPair.EncodedAppend = "%22site%3Aslideshare.net%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Wikipedia";
            //"site:wikipedia.org"
            footprintPair.EncodedAppend = "%22site%3Awikipedia.org%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Tumblr";
            //"site:tumblr.com"
            footprintPair.EncodedAppend = "%22site%3Atumblr.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Typepad";
            //"site:typepad.com"
            footprintPair.EncodedAppend = "%22site%3Atypepad.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Buzzfeed";
            //"site:buzzfeed.com"
            footprintPair.EncodedAppend = "%22site%3Abuzzfeed.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "NYTimes";
            //"site:nytimes.com"
            footprintPair.EncodedAppend = "%22site%3Anytimes.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            footprintPair.ShowString = "Huffington Post";
            //"site:huffingtonpost.com"
            footprintPair.EncodedAppend = "%22site%3Ahuffingtonpost.com%22";
            keyValueListSiteSpecificSites.ValuePairList.Add(footprintPair);

            gFootprintTypeSelList.Add(keyValueListSiteSpecificSites);

            //set footprint type data source
            cmbFootprintType.DataSource = gFootprintTypeSelList;
            cmbFootprintType.DisplayMember = "key";
        }

        private void initChaseFootprint()
        {
            //init combox
            initFootprintTypeAndFootprintString();

            //init defult selection
            cmbFootprintType.SelectedIndex = 0;
        }

        private void frmDropMyLink_Load(object sender, EventArgs e)
        {
#if DEBUG
            txbKeyword.Text = "weight loss";
            cmbSearchType.SelectedIndex = 7;
            //txbExportFilename.Text = "AuthorityCommentFinderSearchResult";
            //txbExportFilename.Text = tpgDropmylink.Text + "SearchResult";
            txbExportFilename.Text = "CurrentSearchResult";
#endif
            this.WindowState = FormWindowState.Maximized;
            initSearchResultGridView();

            initChaseFootprint();
        }

        //update UI according current status
        private void updateUI()
        {
            if (curSearchStatus == search_status.SEARCH_STATUS_STOPPED)
            {
                btnSearch.Enabled = true;
                btnSearch.Text = "Search";

                btnExportToCsv.Enabled = true;
                btnExportToExcel.Enabled = true;
                grbActions.Enabled = true;

                btnStopSearch.Enabled = false;
            }
            else if (curSearchStatus == search_status.SEARCH_STATUS_SEARCHING)
            {
                btnSearch.Enabled = false;
                btnSearch.Text = "Searching";

                grbActions.Enabled = false;
                btnExportToCsv.Enabled = false;
                btnExportToExcel.Enabled = false;

                btnStopSearch.Enabled = true;
            }
        }

        string getCurSearchTail()
        {
            //weight loss

            //weight loss site:.edu inurl:blog "post a comment" -"you must be logged in"
            //weight loss site:.gov inurl:blog "post a comment" -"you must be logged in"
            //weight loss "Allowed HTML tags:"
            //weight loss "angelae8654"
            //weight loss "This blog uses premium CommentLuv" -"The version of CommentLuv on this site is no longer supported."
            //weight loss "Notify me of follow-up comments?" "Submit the word you see below:"
            //weight loss "powered by expressionengine"
            //weight loss site:hubpages.com "hot hubs"
            //weight loss "Enter YourName@YourKeywords"
            //weight loss "get livefyre" "comment help" -"Comments have been disabled for this post"
            //weight loss "if you have a website, link to it here" "post a new comment"
            //weight loss "add to this list" site:squidoo.com
            
            /*
                .edu Blogs
                .gov Blogs
                Anchor Text In Comment Blogs
                Angela's Backlinks
                CommentLuv Premium Blogs
                Do Follow Comment Blogs
                Expression Engine Forums
                Hubpages - Hot Hubs
                KeywordLuv Blogs
                LiveFyre Blogs
                Intense Debate Blogs
                Squidoo lenses - Add To List
             * */


            string curSearchType = "";
            switch (cmbSearchType.SelectedIndex)
            {
                case 0:
                    curSearchType = " site:.edu inurl:blog \"post a comment\" -\"you must be logged in\""; //.edu Blogs
                    break;
                case 1:
                    curSearchType = " site:.gov inurl:blog \"post a comment\" -\"you must be logged in\"";//.gov Blogs
                    break;
                case 2:
                    curSearchType = " \"Allowed HTML tags:\"";//Anchor Text In Comment Blogs
                    break;
                case 3:
                    curSearchType = " \"angelae8654\"";//Angela's Backlinks
                    break;
                case 4:
                    curSearchType = " \"This blog uses premium CommentLuv\" -\"The version of CommentLuv on this site is no longer supported.\"";//CommentLuv Premium Blogs
                    break;
                case 5:
                    curSearchType = " \"Notify me of follow-up comments?\" \"Submit the word you see below:\"";//Do Follow Comment Blogs
                    break;
                case 6:
                    curSearchType = " \"powered by expressionengine\"";//Expression Engine Forums
                    break;
                case 7:
                    curSearchType = " site:hubpages.com \"hot hubs\"";//Hubpages - Hot Hubs
                    break;
                case 8:
                    curSearchType = " \"Enter YourName@YourKeywords\"";//KeywordLuv Blogs
                    break;
                case 9:
                    curSearchType = " \"get livefyre\" \"comment help\" -\"Comments have been disabled for this post\"";//LiveFyre Blogs
                    break;
                case 10:
                    curSearchType = " \"if you have a website, link to it here\" \"post a new comment\"";//Intense Debate Blogs
                    break;
                case 11:
                    curSearchType = " \"add to this list\" site:squidoo.com";//Squidoo lenses - Add To List
                    break;
                default:
                    curSearchType = "";
                    break;

            }
            return curSearchType;
        }
        
        void processEachSearchItem(searchItemInfo singleItemInfo)
        {
            singleItemInfo.domainUrl = crifanLib.getDomainUrl(singleItemInfo.url);
#if LATE_CALC_RANK
            singleItemInfo.pageRank = invalidRankValue;
            singleItemInfo.alexaRank = invalidRankValue;
#else
            singleItemInfo.pageRank = crifanLib.getDomainPageRank(singleItemInfo.domainUrl);
            singleItemInfo.alexaRank = crifanLib.getDomainAlexaRank(singleItemInfo.domainUrl);
#endif

            dgvSearchResult.Rows.Add(
                singleItemInfo.title,
                singleItemInfo.url,
                singleItemInfo.pageRank,
                singleItemInfo.alexaRank);

            visitUrlColumn.DataGridView.Rows[dgvSearchResult.Rows.Count - 1].Cells[visitUrlColumnIdx].Value = "View Page";
            visitUrlColumn.DataGridView.Rows[dgvSearchResult.Rows.Count - 1].Cells[visitUrlColumnIdx].Tag = singleItemInfo.url;

            crifanLib.dgvDrawHeaderNum(dgvSearchResult);

            //update UI
            System.Windows.Forms.Application.DoEvents();
        }

        public struct searchItemInfo
        {
            public string title;
            public string url;
            public string domainUrl;
            public int pageRank;
            public int alexaRank;
        };
        
        private void parseSinglePageHtml(string singlePageGoogleHtml)
        {
            //<h3 class="r"><a href="http://bloodcenter.stanford.edu/blog/archives/2011/04/type-2-diabetes.html" target=_blank class=l onmousedown="return rwt(this,'','','','11','AFQjCNEbtRkzYDSJUigURl6AUHmlBGtY-A','','0CDAQFjAAOAo','','',event)">Type-2 Diabetes an Autoimmune Disease? - Hemoblogin - School <b>...</b></a></h3>
            HtmlAgilityPack.HtmlDocument htmlDoc = crifanLib.htmlToHtmlDoc(singlePageGoogleHtml);
            HtmlNode rootHtmlNode = htmlDoc.DocumentNode;
            HtmlNodeCollection h3aHtmlNodes = rootHtmlNode.SelectNodes("//h3[@class='r']/a");
            foreach (HtmlNode h3aNode in h3aHtmlNodes)
            {
                if (needContinueSearch)
                {
                    searchItemInfo singleItemInfo = new searchItemInfo();

                    //InnerHtml
                    //"Losing <em>weight</em> and belly fat improves sleep - Harvard Health <b>...</b>"
                    //InnerText:
                    //"Losing weight and belly fat improves sleep - Harvard Health ..."
                    string undecodedTitle = h3aNode.InnerText;
                    singleItemInfo.title = HttpUtility.HtmlDecode(undecodedTitle);

                    singleItemInfo.url = h3aNode.Attributes["href"].Value;

                    processEachSearchItem(singleItemInfo);
                }
                else
                {
                    break;
                }
            } 
        }

        //private void processXjs(string respHtml) 
        //{
        //    //extract xjs url
        //    //google.dljp('/xjs/_/js/s/c,sb,cr,cdos,vm,tbui,mb,wobnm,cfm,abd,bihu,kp,lu,m,tnv,amcl,hv,lc,ob,r,rsn,sf,sfa,shb,tbpr,hsm,j,pcc,csi/rt\x3dj/ver\x3dADVrJ2nu1R4.en_US./am\x3dAAE/d\x3d1/sv\x3d1/rs\x3dAItRSTP8CWiu2moML2ZpukqdhJfoo-cmkA');
        //    string xjsUrl = "";
        //    if (crifanLib.extractSingleStr(@"google\.dljp\('(.+?)'\);", respHtml, out xjsUrl))
        //    {
        //        //http://www.google.com.hk/xjs/_/js/s/c,sb,cr,cdos,tbui,mb,wobnm,cfm,abd,bihu,kp,lu,m,tnv,amcl,hv,lc,ob,r,rsn,sf,sfa,shb,tbpr,hsm,pcc,csi/rt=j/ver=ADVrJ2nu1R4.en_US./am=AAE/d=1/sv=1/rs=AItRSTP8CWiu2moML2ZpukqdhJfoo-cmkA
        //        xjsUrl = "http://www.google.com.hk" + xjsUrl;
        //        xjsUrl = HttpUtility.HtmlDecode(xjsUrl);
        //        string tmpXjsRespHtml = crifanLib.getUrlRespHtml(xjsUrl);
        //    }
        //}

        private void afterSearch()
        {
#if LATE_CALC_RANK
            for (int rowIdx = 0; rowIdx < dgvSearchResult.Rows.Count; rowIdx++)
            {
                if (needContinueSearch)
                {
                    DataGridViewRow curRow = dgvSearchResult.Rows[rowIdx];
                    DataGridViewCell urlCell = curRow.Cells[urlColumnIdx];
                    string domainUrl = crifanLib.getDomainUrl(urlCell.Value.ToString());
                    DataGridViewCell pageRankCell = curRow.Cells[pageRankColumnIdx];

                    if (pageRankCell.Value.Equals(invalidRankValue))
                    {
                        pageRankCell.Value = crifanLib.getDomainPageRank(domainUrl);
                    }
                    else
                    {
                        //not do again
                    }

                    DataGridViewCell alexaRankCell = curRow.Cells[alexaRankColumnIdx];
                    if (alexaRankCell.Value.Equals(invalidRankValue))
                    {
                        alexaRankCell.Value = crifanLib.getDomainAlexaRank(domainUrl);
                    }
                    else
                    {
                        //not do again
                    }
                }
                else
                {
                    break;
                }
            }
#endif
        }

        private void searchAndParse(string searchStr)
        {
            Dictionary<string, string> queryPara;
            Dictionary<string, string> headerDict;
            string curGoogleSearchUrl;
            string curSearchRespHtml;
            string curReferer;
            //string ei = "";

            //1. for get cookie and related url
            string googleUrl = "http://www.google.com.hk/";
            string tmpRespHtml = crifanLib.getUrlRespHtml_multiTry(googleUrl);
            //processXjs(tmpRespHtml);

            //2. do first search
            //weight loss site:.edu inurl:blog "post a comment" -"you must be logged in"
            //http://www.google.com.hk/search?newwindow=1&safe=strict&site=&source=hp&q=weight+loss+site%3A.edu+inurl%3Ablog+%22post+a+comment%22+-%22you+must+be+logged+in%22&btnK=Google+Search

            //http://www.google.com.hk/search
            //?newwindow=1
            //&safe=strict
            //&site=
            //&source=hp
            //&q=weight+loss+site%3A.edu+inurl%3Ablog+%22post+a+comment%22+-%22you+must+be+logged+in%22
            //&btnK=Google+Search
            string firstGoogleSearchUrl = "http://www.google.com.hk/search?";
            queryPara = new Dictionary<string, string>();
            queryPara.Add("newwindow", "1");
            queryPara.Add("safe", "strict");
            queryPara.Add("source", "hp");
            queryPara.Add("q", searchStr);
            queryPara.Add("btnK", "Google Search");

            queryPara.Add("site", "");
            //queryPara.Add("site", "webhp");

            //http://www.google.com.hk/search?newwindow=1&safe=strict&hl=zh-CN&site=webhp&source=hp&q=unit&btnK=Google+%E6%90%9C%E7%B4%A2
            
            //firstGoogleSearchUrl += crifanLib.quoteParas(queryPara);
            firstGoogleSearchUrl += crifanLib.quoteParas(queryPara, false);
            //http://www.google.com.hk/search?newwindow=1&safe=strict&site=&source=hp&q=weight+loss+site%3a.edu+inurl%3ablog+%22post+a+comment%22+-%22you+must+be+logged+in%22&btnK=Google+Search

            curReferer = googleUrl;
            curGoogleSearchUrl = firstGoogleSearchUrl;

            //3. continue to search current page and next page ...
            while(needContinueSearch)
            {
                headerDict = new Dictionary<string,string>();
                headerDict.Add("referer", curReferer);
                curSearchRespHtml = crifanLib.getUrlRespHtml_multiTry(curGoogleSearchUrl, headerDict: headerDict);
                
                //processXjs(tmpRespHtml);

                parseSinglePageHtml(curSearchRespHtml);
                if (!needContinueSearch)
                {
                    break;
                }

                ////window.google={kEI:"XZp2UczlE8nYigeK5IHgCg"
                ////get ei for next page
                //if(crifanLib.extractSingleStr(@"window.google={kEI:""(\w+)""", curSearchRespHtml, out ei))
                //{

                //}

                //check need get more page or not
                //<a href="/search?q=weight+loss+site:.edu+inurl:blog+%22post+a+comment%22+-%22you+must+be+logged+in%22&amp;newwindow=1&amp;safe=strict&amp;ei=XZp2UczlE8nYigeK5IHgCg&amp;start=10&amp;sa=N" class="pn" id="pnnext" style="text-decoration:none;text-align:left"><span class="csb gbil ch" style="background-position:-96px 0;width:71px"></span><span style="display:block;margin-left:53px;text-decoration:underline">Next</span></a>
                HtmlAgilityPack.HtmlDocument htmlDoc = crifanLib.htmlToHtmlDoc(curSearchRespHtml);
                HtmlNode rootHtmlNode = htmlDoc.DocumentNode;
                HtmlNode nextHtmlNode = rootHtmlNode.SelectSingleNode("//a[@id='pnnext' and @class='pn']");
                if(nextHtmlNode != null)
                {
                    //before update google url, store it to refer for next search use
                    curReferer = curGoogleSearchUrl;

                    //Method 2: extract net page url
                    string hrefStr = nextHtmlNode.Attributes["href"].Value;
                    //string decodedUrl = HttpUtility.HtmlDecode(hrefStr);
                    //string decodedUrl = HttpUtility.UrlDecode(hrefStr);

                    //string nextPageUrl = googleUrl + hrefStr;
                    string encodedUrl = "http://www.google.com.hk" + hrefStr;

                    //http://www.google.com.hk/search?q=weight+loss+site:.edu+inurl:blog+%22post+a+comment%22+-%22you+must+be+logged+in%22&newwindow=1&safe=strict&ei=XZp2UczlE8nYigeK5IHgCg&start=10&sa=N
                    //"http://www.google.com.hk/search?q=weight+loss+%22powered+by+expressionengine%22&amp;newwindow=1&amp;safe=strict&amp;ei=RKZ3Ubf2JqqUiQeN5YHQBg&amp;start=10&amp;sa=N"
                    string htmlDecoded = HttpUtility.HtmlDecode(encodedUrl);
                    //"http://www.google.com.hk/search?q=weight+loss+%22powered+by+expressionengine%22&newwindow=1&safe=strict&ei=RKZ3Ubf2JqqUiQeN5YHQBg&start=10&sa=N"
                    curGoogleSearchUrl = htmlDecoded;
                    
                    ////method 1: generate nex page url
                    ////http://www.google.com.hk/search?q=weight+loss+site:.edu+inurl:blog+%22post+a+comment%22+-%22you+must+be+logged+in%22&newwindow=1&safe=strict&ei=XZp2UczlE8nYigeK5IHgCg&start=10&sa=N
                    //string startNumStr = "";
                    //if (crifanLib.extractSingleStr(@"&start=(\d+)&", curGoogleSearchUrl, out startNumStr))
                    //{
                    //    int startNumInt = Int32.Parse(startNumStr);
                    //    int nextStartNumInt = startNumInt + 10;
                    //    string nextStartNumStr = nextStartNumInt.ToString();

                    //    curGoogleSearchUrl = curGoogleSearchUrl.Replace("&start=" + startNumStr, "&start=" + nextStartNumStr);
                    //}
                    //else
                    //{
                    //    //is the first page
                    //    //http://www.google.com.hk/search?newwindow=1&safe=strict&source=hp&q=weight+loss+%22Allowed+HTML+tags%3a%22&btnK=Google+Search&site=
                                                
                    //    //Method 2: extract net page url
                    //    string hrefStr = nextHtmlNode.Attributes["href"].Value;
                    //    //string decodedUrl = HttpUtility.HtmlDecode(hrefStr);
                    //    //string decodedUrl = HttpUtility.UrlDecode(hrefStr);

                    //    //string nextPageUrl = googleUrl + hrefStr;
                    //    string encodedUrl = "http://www.google.com.hk" + hrefStr;

                    //    //http://www.google.com.hk/search?q=weight+loss+site:.edu+inurl:blog+%22post+a+comment%22+-%22you+must+be+logged+in%22&newwindow=1&safe=strict&ei=XZp2UczlE8nYigeK5IHgCg&start=10&sa=N
                    //    //"http://www.google.com.hk/search?q=weight+loss+%22powered+by+expressionengine%22&amp;newwindow=1&amp;safe=strict&amp;ei=RKZ3Ubf2JqqUiQeN5YHQBg&amp;start=10&amp;sa=N"
                    //    string htmlDecoded = HttpUtility.HtmlDecode(encodedUrl);
                    //    //"http://www.google.com.hk/search?q=weight+loss+%22powered+by+expressionengine%22&newwindow=1&safe=strict&ei=RKZ3Ubf2JqqUiQeN5YHQBg&start=10&sa=N"
                    //    curGoogleSearchUrl = htmlDecoded;
                    //}

                    needContinueSearch = true;
                }
                else
                {
                    afterSearch();

                    needContinueSearch = false;
                    break;
                }
            }            
        }

        private void startSearchDropmylink()
        {
            //generate search string
            string searchStr = "";
            searchStr += txbKeyword.Text;
            searchStr += getCurSearchTail();

            searchAndParse(searchStr);
        }

        private void startSearchChaseFootprint()
        {
            ////choose: Sponsor/Donate -> Sponsor Charity
            //// ->
            ////http://www.google.com.hk/search?q=weight%20loss+%22sponsor%20charity%22
            ////->
            ////http://www.google.com.hk/search?q=weight loss+"sponsor charity"
            //string strCurFootprint = getCurrentFootprint(); //"Sponsor Charity"
            //string strEncodedFootprint = HttpUtility.UrlPathEncode(strCurFootprint); //"Sponsor%20Charity"

            //string strKeyword = txbKeywordChaseFootprint.Text; //"weight loss"
            //string strEncodedKeyword = HttpUtility.UrlPathEncode(strKeyword); //"weight%20loss"

            //string strUrlPrefix = "http://www.google.com.hk/search?q=";
            //string strEncodedFullFootprintUrl = String.Format("{0}{1}+%22{2}%22", strUrlPrefix, strEncodedKeyword, strEncodedFootprint); //"http://www.google.com.hk/search?q=weight%20loss+%22Sponsor%20Charity%22"


            //"%22Powered%20by%20JComments%22"
            footprintPair curFootprintPair = getCurrentFootprintPair();
            string strCurEncodedRealAppendFootprint = curFootprintPair.EncodedAppend; //"%22guest%20blogger%22%20OR%20%22guest%20post%22%20OR%20%22guest%20article%22%20OR%20%22Add%20Guest%20Post%22%20OR%20%22Submit%20Guest%20Post%22%20OR%20%22Submit%20a%20Guest%20Article%22%20OR%20%22Guest%20Post%20Guidelines%22"

            string strKeyword = txbKeywordChaseFootprint.Text; //"weight loss"
            string strEncodedKeyword = HttpUtility.UrlPathEncode(strKeyword); //"weight%20loss"
            string strUrlPrefix = "http://www.google.com.hk/search?q=";
            string strEncodedFullFootprintUrl = "";
            if (curFootprintPair.BAppendKeywordToEnd)
            {
                strEncodedFullFootprintUrl = strUrlPrefix + strCurEncodedRealAppendFootprint + "+" + strEncodedKeyword; //"http://www.google.com.hk/search?q=allinurl%3A+weight%20loss"
            }
            else
            {
                strEncodedFullFootprintUrl = strUrlPrefix + strEncodedKeyword + "+" + strCurEncodedRealAppendFootprint; //"http://www.google.com.hk/search?q=weight%20loss+%22Powered%20by%20JComments%22"
            }

            //http://www.google.com.hk/search?q=weight%20loss+%22Sponsor%20Charity%22
            wbsChaseFootprint.Url = new Uri(strEncodedFullFootprintUrl);
        }

        private void startSearch()
        {
            if (tbcSearch.SelectedTab == tpgDropmylink)
            {
                startSearchDropmylink();
            }
            else if (tbcSearch.SelectedTab == tpgChaseFootprint)
            {
                startSearchChaseFootprint();
            }
        }

        private void clearSearchResult()
        {
            crifanLib.dgvClearContent(dgvSearchResult);
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            if (curSearchStatus == search_status.SEARCH_STATUS_STOPPED)
            {
                clearSearchResult();

                needContinueSearch = true;

                //start search
                curSearchStatus = search_status.SEARCH_STATUS_SEARCHING;
                updateUI();

                startSearch();

                curSearchStatus = search_status.SEARCH_STATUS_STOPPED;
                updateUI();
            }
        }

        private void stopSearch()
        {
            if (tbcSearch.SelectedTab == tpgDropmylink)
            {
                
            }
            else if (tbcSearch.SelectedTab == tpgChaseFootprint)
            {
                wbsChaseFootprint.Stop();
                //afterSearchComplete();
            }
        }
        
        private void btnStopSearch_Click(object sender, EventArgs e)
        {
            if (curSearchStatus == search_status.SEARCH_STATUS_SEARCHING)
            {
                curSearchStatus = search_status.SEARCH_STATUS_STOPPED;
                updateUI();

                //do stop things
                stopSearch();
                needContinueSearch = false;
            }
        }

        private void btnExportToExcel_Click(object sender, EventArgs e)
        {
            string saveFolderPath = crifanLib.getSaveFolder(fbdSaveFolder);
            if ((saveFolderPath == null) || (saveFolderPath == ""))
            {
                return;
            }

            string outputFilename = txbExportFilename.Text + ".xls";
            string fullFilename = Path.Combine(saveFolderPath, outputFilename);

            List<int> omitColumnIdxList = new List<int>();
            //omit the last column: View page
            omitColumnIdxList.Add(dgvSearchResult.ColumnCount - 1);

            crifanLib.dgvExportToExcel(dgvSearchResult, fullFilename, omitColumnIdxList: omitColumnIdxList);

            crifanLib.openFolderAndSelectFile(fullFilename);
        }

        private void btnExportToCsv_Click(object sender, EventArgs e)
        {
            string saveFolderPath = crifanLib.getSaveFolder(fbdSaveFolder);
            if ((saveFolderPath == null) || (saveFolderPath == ""))
            {
                return;
            }

            string outputFilename = txbExportFilename.Text + ".csv";
            string fullFilename = Path.Combine(saveFolderPath, outputFilename);

            List<int> omitColumnIdxList = new List<int>();
            //omit the last column: View page
            omitColumnIdxList.Add(dgvSearchResult.ColumnCount - 1);

            crifanLib.dgvExportToCsv(dgvSearchResult, fullFilename, omitColumnIdxList: omitColumnIdxList);

            //after save file
            crifanLib.openFolderAndSelectFile(fullFilename);
        }

        private void btnClearAll_Click(object sender, EventArgs e)
        {
            crifanLib.dgvClearContent(dgvSearchResult);
        }
        
        private void cmbFootprintType_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbFootprintType.SelectedItem != null)
            {
                //keyValueList curSelFootprintType = (keyValueList)cmbFootprintType.SelectedItem;
                //List<string> footprintSelectionValueList = curSelFootprintType.ValuePairList;
                //cmbFootprintStr.DataSource = footprintSelectionValueList;

                keyValueList curSelFootprintType = (keyValueList)cmbFootprintType.SelectedItem;
                List<footprintPair> footprintSelectionValueList = curSelFootprintType.ValuePairList;
                cmbFootprintStr.DataSource = footprintSelectionValueList;
                cmbFootprintStr.DisplayMember = "showString";
            }
        }

        private footprintPair getCurrentFootprintPair()
        {
            footprintPair curFootprintPair = new footprintPair();
            if (cmbFootprintStr.SelectedItem != null)
            {
                //curFootprint = (string)cmbFootprintStr.SelectedItem;
                curFootprintPair = (footprintPair)cmbFootprintStr.SelectedItem;
            }
            return curFootprintPair;
        }

        //private void searchChaseFootprint()
        //{
        //}


        ////update UI according current status
        //private void updateUI_footprint()
        //{
        //    if (curSearchStatus_footprint == search_status.SEARCH_STATUS_STOPPED)
        //    {
        //        btnSearchChaseFootprint.Enabled = true;
        //        btnSearchChaseFootprint.Text = "Search";

        //        btnStopChaseFootprint.Enabled = false;
        //    }
        //    else if (curSearchStatus_footprint == search_status.SEARCH_STATUS_SEARCHING)
        //    {
        //        btnSearchChaseFootprint.Enabled = false;
        //        btnSearchChaseFootprint.Text = "Searching";

        //        btnStopChaseFootprint.Enabled = true;
        //    }
        //}

        //private void btnSearchChaseFootprint_Click(object sender, EventArgs e)
        //{
        //    if (curSearchStatus_footprint == search_status.SEARCH_STATUS_STOPPED)
        //    {
        //        txbOutput.Text = "";

        //        needContinueSearch = true;

        //        //start search
        //        curSearchStatus_footprint = search_status.SEARCH_STATUS_SEARCHING;
        //        updateUI_footprint();

                
        //    }
        //}

        //private void afterSearchComplete()
        //{
        //    curSearchStatus_footprint = search_status.SEARCH_STATUS_STOPPED;
        //    updateUI_footprint();
        //}

        private void wbsChaseFootprint_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            //if (wbsChaseFootprint.ReadyState != WebBrowserReadyState.Complete)
            //{
            //    //not actually complete, do nothing
            //    return;
            //}

            if (!e.Url.Equals(wbsChaseFootprint.Url))
            {
                //not actually complete, do nothing
                return;
            }

            string curHtml = wbsChaseFootprint.DocumentText;
            //System.Windows.Forms.HtmlDocument htmlDoc = wbsChaseFootprint.Document;

            List<crifanLibGoogle.googleSearchResultItem> resultItemList = google.extractGoogleSearchResult("", curHtml);
            if ((resultItemList != null) && (resultItemList.Count > 0))
            {
                //txbOutput.Text = "";

                foreach (crifanLibGoogle.googleSearchResultItem singleResultItem in resultItemList)
                {
                    //txbOutput.Text += singleResultItem.Url + Environment.NewLine;

                    searchItemInfo singleItemInfo = new searchItemInfo();

                    singleItemInfo.title = singleResultItem.Title;
                    singleItemInfo.url = singleResultItem.Url;

                    processEachSearchItem(singleItemInfo);
                }
            }

            //afterSearchComplete();
            //debug
            afterSearch();
        }

        private void dgvSearchResult_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if ((e.RowIndex >= 0) && (e.ColumnIndex == visitUrlColumnIdx))
            {
                DataGridViewButtonCell clickedButtonCell = (DataGridViewButtonCell)dgvSearchResult.Rows[e.RowIndex].Cells[e.ColumnIndex];
                System.Diagnostics.Process.Start(clickedButtonCell.Tag.ToString());
            }
        }


        ////sometime WebBrowser can not goto DocumentCompleted
        ////so need here force stop
        //private void btnStopChaseFootprint_Click(object sender, EventArgs e)
        //{
        //    wbsChaseFootprint.Stop();
        //    afterSearchComplete();
        //}
    }
}
