#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Function:
̡̳ץȡ˲ƾĴҵϢΪηģ⶯̬ҳץȡ
http://www.crifan.com/take_scrape_sina_finance_creator_info_as_example_to_teach_how_to_analysis_the_data

Version:    2013-04-30
Author:     Crifan
Contact:    admin (at) crifan.com
"""

import re;
import sys;
sys.path.append("libs");

import crifanLib;
import logging;

def main():
    """
        take sina finance as example, to demo how to analysis and write code to emulate the internal process of hwo to get the dynamic data
    """
    
    #http://vip.stock.finance.sina.com.cn/quotes_service/api/json_v2.php/Market_Center.getHQNodeData?page=1&num=40&sort=symbol&asc=1&node=cyb&_s_r_a=init
    getNodeDataBaseUrl = "http://vip.stock.finance.sina.com.cn/quotes_service/api/json_v2.php/Market_Center.getHQNodeData";
    paraDict = {
        'page'  : "1",
        'num'   : "40",
        'sort'  : "symbol",
        'asc'   : "1",
        'node'  : "cyb",
        '_s_r_a': "init",
    };
    getNodeDataUrl = crifanLib.genFullUrl(getNodeDataBaseUrl, paraDict);
    logging.info("getNodeDataUrl=%s", getNodeDataUrl);
    headerDict = {
        'Referer'       : "http://autoexplosion.com/cars/buy/advanced.php",
        'Content-Type'  : "application/x-www-form-urlencoded",
    };
    getNodeDataRespHtml = crifanLib.getUrlRespHtml(getNodeDataUrl, headerDict=headerDict);
    logging.debug("getNodeDataRespHtml=%s", getNodeDataRespHtml);
    
    #here, luckly, has got the expected response json string
    #getNodeDataRespHtml=[{symbol:"sz300001",code:"300001",name:"",t ...... }]

###############################################################################
if __name__=="__main__":
    scriptSelfName = crifanLib.extractFilename(sys.argv[0]);

    logging.basicConfig(
                    level    = logging.DEBUG,
                    format   = 'LINE %(lineno)-4d  %(levelname)-8s %(message)s',
                    datefmt  = '%m-%d %H:%M',
                    filename = scriptSelfName + ".log",
                    filemode = 'w');
    # define a Handler which writes INFO messages or higher to the sys.stderr
    console = logging.StreamHandler();
    console.setLevel(logging.INFO);
    # set a format which is simpler for console use
    formatter = logging.Formatter('LINE %(lineno)-4d : %(levelname)-8s %(message)s');
    # tell the handler to use this format
    console.setFormatter(formatter);
    logging.getLogger('').addHandler(console);
    try:
        main();
    except:
        logging.exception("Unknown Error !");
        raise;