﻿/*
 * [Function]
* Emulate Baidu login using C# code, .NET 4.0, independent code version
 * http://www.crifan.com/emulate_login_website_using_csharp/
 * 
 * [Author]
 * Crifan Li
 * 
 * [Date]
 * 2013-09-11
 * 
 * [Contact]
 * http://www.crifan.com/contact_me/
 * 
 * [Note]
 * 1.Crifan's C# Library
 * http://www.crifan.com/files/doc/docbook/crifanlib_csharp/release/html/crifanlib_csharp.html
 * 
 * 2.
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Net;
using System.IO;
using System.Text.RegularExpressions;
using System.Web;

using System.Globalization;

namespace emulateLoginBaidu
{
    public partial class frmEmulateLoginBaidu : Form
    {
        bool gotCookieBaiduid, extractTokenValueOK, loginBaiduOk;

        public frmEmulateLoginBaidu()
        {
            //crifanLib related init
            //set max enough to avoid http request is used out -> avoid dead while get response 
            System.Net.ServicePointManager.DefaultConnectionLimit = 200;
            
            InitializeComponent();
        }

        private void initForCrifanLibFunctions()
        {
            //http related
            gUserAgent = constUserAgent_IE8_x64;
            //set max enough to avoid http request is used out -> avoid dead while get response 
            System.Net.ServicePointManager.DefaultConnectionLimit = 200;

            gCurCookies = new CookieCollection();
            // init const cookie keys
            foreach (string key in cookieFieldArr)
            {
                cookieFieldList.Add(key);
            }
        }
        
        private void frmEmulateLoginBaidu_Load(object sender, EventArgs e)
        {
            //init for crifanLib.cs
            initForCrifanLibFunctions();

            this.AcceptButton = this.btnEmulateLoginBaidu;
            
            //init for demo login
            gotCookieBaiduid = false;
            extractTokenValueOK = false;
            loginBaiduOk = false;
        }

        /******************************************************************************
        functions in crifanLib.cs
        Crifan's C# Library
        http://www.crifan.com/files/doc/docbook/crifanlib_csharp/release/html/crifanlib_csharp.html
        *******************************************************************************/

        const char replacedChar = '_';

        const string constStrExpires = "expires";
        string[] cookieFieldArr = { constStrExpires, "domain", "secure", "path", "httponly", "version" };

        //IE7
        const string constUserAgent_IE7_x64 = "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.3; .NET4.0C; .NET4.0E)";
        //IE8
        const string constUserAgent_IE8_x64 = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; InfoPath.3; .NET4.0C; .NET4.0E";
        //IE9
        const string constUserAgent_IE9_x64 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)"; // x64
        const string constUserAgent_IE9_x86 = "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)"; // x86
        //Chrome
        const string constUserAgent_Chrome = "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US) AppleWebKit/533.4 (KHTML, like Gecko) Chrome/5.0.375.99 Safari/533.4";
        //Mozilla Firefox
        const string constUserAgent_Firefox = "Mozilla/5.0 (Windows; U; Windows NT 6.1; rv:1.9.2.6) Gecko/20100625 Firefox/3.6.6";
        private string gUserAgent = null;

        //detault values:
        //getUrlResponse
        private const Dictionary<string, string> defHeaderDict = null;
        private const Dictionary<string, string> defPostDict = null;
        private const int defTimeout = 30 * 1000;
        private const string defPostDataStr = null;
        private const int defReadWriteTimeout = 30 * 1000;
        //getUrlRespHtml 
        private const string defCharset = null;

        private WebProxy gProxy = null;
        
        List<string> cookieFieldList = new List<string>();

        CookieCollection gCurCookies = null;

        public struct pairItem
        {
            public string key;
            public string value;
        };
        
        //replace ',' with replacedChar
        private string _processExpireField(Match foundExpire)
        {
            string replacedComma = "";
            replacedComma = foundExpire.Value.ToString().Replace(',', replacedChar);
            return replacedComma;
        }

        //check whether need add/retain this cookie
        // not add for:
        // ck is null or ck name is null
        // domain is null and curDomain is not set
        // expired and retainExpiredCookie==false
        private bool needAddThisCookie(Cookie ck, string curDomain)
        {
            bool needAdd = false;

            if ((ck == null) || (ck.Name == ""))
            {
                needAdd = false;
            }
            else
            {
                if (ck.Domain != "")
                {
                    needAdd = true;
                }
                else// ck.Domain == ""
                {
                    if (curDomain != "")
                    {
                        ck.Domain = curDomain;
                        needAdd = true;
                    }
                    else // curDomain == ""
                    {
                        // not set current domain, omit this
                        // should not add empty domain cookie, for this will lead execute CookieContainer.Add() fail !!!
                        needAdd = false;
                    }
                }
            }

            return needAdd;
        }
        
        // replace the replacedChar back to original ','
        private string _recoverExpireField(Match foundPprocessedExpire)
        {
            string recovedStr = "";
            recovedStr = foundPprocessedExpire.Value.Replace(replacedChar, ',');
            return recovedStr;
        }

        /*********************************************************************/
        /* Array */
        /*********************************************************************/

        //given a string array 'origStrArr', get a sub string array from 'startIdx', length is 'len'
        public string[] getSubStrArr(string[] origStrArr, int startIdx, int len)
        {
            string[] subStrArr = new string[] { };
            if ((origStrArr != null) && (origStrArr.Length > 0) && (len > 0))
            {
                List<string> strList = new List<string>();
                int endPos = startIdx + len;
                if (endPos > origStrArr.Length)
                {
                    endPos = origStrArr.Length;
                }

                for (int i = startIdx; i < endPos; i++)
                {
                    //refer: http://zhidao.baidu.com/question/296384408.html
                    strList.Add(origStrArr[i]);
                }

                subStrArr = new string[len];
                strList.CopyTo(subStrArr);
            }

            return subStrArr;
        }

        /*********************************************************************/
        /* Cookie */
        /*********************************************************************/

        /*
         * Note: currently support auto handle cookies
         * currently only support single caller -> multiple caller of these functions will cause cookies accumulated
         * you can clear previous cookies to avoid unexpected result by call clearCurCookies
         */
        public void clearCurCookies()
        {
            if (gCurCookies != null)
            {
                gCurCookies = null;
                gCurCookies = new CookieCollection();
            }
        }

        /* get current cookies */
        public CookieCollection getCurCookies()
        {
            return gCurCookies;
        }

        /* set current cookies */
        public void setCurCookies(CookieCollection cookies)
        {
            gCurCookies = cookies;
        }

        //extrat the Host from input url
        //example: from https://skydrive.live.com/, extracted Host is "skydrive.live.com"
        public string extractHost(string url)
        {
            string domain = "";
            if ((url != "") && (url.Contains("/")))
            {
                string[] splited = url.Split('/');
                domain = splited[2];
            }
            return domain;
        }

        //extrat the domain from input url
        //example: from https://skydrive.live.com/, extracted domain is ".live.com"
        public string extractDomain(string url)
        {
            string host = "";
            string domain = "";
            host = extractHost(url);
            if (host.Contains("."))
            {
                domain = host.Substring(host.IndexOf('.'));
            }
            return domain;
        }

        //extrat the domain url from original url
        //from
        //http://answers.yahoo.com/question/index?qid=20130323071141AA8PffP
        //get
        //http://answers.yahoo.com
        public string getDomainUrl(string url)
        {
            string domainUrl = "";

            Regex urlRx = new Regex(@"((https)|(http)|(ftp))://[\w\-\.]+");
            Match foundUrl = urlRx.Match(url);
            if (foundUrl.Success)
            {
                //int slashIndex = foundUrl.Index + foundUrl.Length;
                domainUrl = url.Substring(0, foundUrl.Length);
            }
            else
            {
                domainUrl = "";
            }

            return domainUrl;
        }

        //add recognized cookie field: expires/domain/path/secure/httponly/version, into cookie
        public bool addFieldToCookie(ref Cookie ck, pairItem pairInfo)
        {
            bool added = false;
            if (pairInfo.key != "")
            {
                string lowerKey = pairInfo.key.ToLower();
                switch (lowerKey)
                {
                    case "expires":
                        DateTime expireDatetime;
                        bool parseDatetimeOk = false;
                        //【记录】C#中尝试用DateTime.TryParse去解析特定日期时间的格式："Wed, 11-Sep-43 05:54:19 GMT"
                        //http://www.crifan.com/try_use_csharp_datetime_tryparse_to_parse_date_time_string_to_datetime_value/
                        parseDatetimeOk = DateTime.TryParse(pairInfo.value, out expireDatetime);
                        if (parseDatetimeOk)
                        {
                            // note: here coverted to local time: GMT +8
                            ck.Expires = expireDatetime;

                            //update expired filed
                            if (DateTime.Now.Ticks > ck.Expires.Ticks)
                            {
                                ck.Expired = true;
                            }

                            added = true;
                        }
                        break;
                    case "domain":
                        ck.Domain = pairInfo.value;
                        added = true;
                        break;
                    case "secure":
                        ck.Secure = true;
                        added = true;
                        break;
                    case "path":
                        ck.Path = pairInfo.value;
                        added = true;
                        break;
                    case "httponly":
                        ck.HttpOnly = true;
                        added = true;
                        break;
                    case "version":
                        int versionValue;
                        if (int.TryParse(pairInfo.value, out versionValue))
                        {
                            ck.Version = versionValue;
                            added = true;
                        }
                        break;
                    default:
                        break;
                }
            }

            return added;
        }//addFieldToCookie

        public bool isValidCookieField(string cookieKey)
        {
            return cookieFieldList.Contains(cookieKey.ToLower());
        }

        //cookie field example:
        //WLSRDAuth=FAAaARQL3KgEDBNbW84gMYrDN0fBab7xkQNmAAAEgAAACN7OQIVEO14E2ADnX8vEiz8fTuV7bRXem4Yeg/DI6wTk5vXZbi2SEOHjt%2BbfDJMZGybHQm4NADcA9Qj/tBZOJ/ASo5d9w3c1bTlU1jKzcm2wecJ5JMJvdmTCj4J0oy1oyxbMPzTc0iVhmDoyClU1dgaaVQ15oF6LTQZBrA0EXdBxq6Mu%2BUgYYB9DJDkSM/yFBXb2bXRTRgNJ1lruDtyWe%2Bm21bzKWS/zFtTQEE56bIvn5ITesFu4U8XaFkCP/FYLiHj6gpHW2j0t%2BvvxWUKt3jAnWY1Tt6sXhuSx6CFVDH4EYEEUALuqyxbQo2ugNwDkP9V5O%2B5FAyCf; path=/; domain=.livefilestore.com;  HttpOnly;,
        //WLSRDSecAuth=FAAaARQL3KgEDBNbW84gMYrDN0fBab7xkQNmAAAEgAAACJFcaqD2IuX42ACdjP23wgEz1qyyxDz0kC15HBQRXH6KrXszRGFjDyUmrC91Zz%2BgXPFhyTzOCgQNBVfvpfCPtSccxJHDIxy47Hq8Cr6RGUeXSpipLSIFHumjX5%2BvcJWkqxDEczrmBsdGnUcbz4zZ8kP2ELwAKSvUteey9iHytzZ5Ko12G72%2Bbk3BXYdnNJi8Nccr0we97N78V0bfehKnUoDI%2BK310KIZq9J35DgfNdkl12oYX5LMIBzdiTLwN1%2Bx9DgsYmmgxPbcuZPe/7y7dlb00jNNd8p/rKtG4KLLT4w3EZkUAOcUwGF746qfzngDlOvXWVvZjGzA; path=/; domain=.livefilestore.com;  HttpOnly; secure;,
        //RPSShare=1; path=/;,
        //ANON=A=DE389D4D076BF47BCAE4DC05FFFFFFFF&E=c44&W=1; path=/; domain=.livefilestore.com;,
        //NAP=V=1.9&E=bea&C=VTwb1vAsVjCeLWrDuow-jCNgP5eS75JWWvYVe3tRppviqKixCvjqgw&W=1; path=/; domain=.livefilestore.com;,
        //RPSMaybe=; path=/; domain=.livefilestore.com; expires=Thu, 30-Oct-1980 16:00:00 GMT;

        //check whether the cookie name is valid or not
        public bool isValidCookieName(string ckName)
        {
            bool isValid = true;
            if (ckName == null)
            {
                isValid = false;
            }
            else
            {
                string invalidP = @"\W+";
                Regex rx = new Regex(invalidP);
                Match foundInvalid = rx.Match(ckName);
                if (foundInvalid.Success)
                {
                    isValid = false;
                }
            }

            return isValid;
        }

        // parse the cookie name and value
        public bool parseCookieNameValue(string ckNameValueExpr, out pairItem pair)
        {
            bool parsedOK = false;
            if (ckNameValueExpr == "")
            {
                pair.key = "";
                pair.value = "";
                parsedOK = false;
            }
            else
            {
                ckNameValueExpr = ckNameValueExpr.Trim();

                int equalPos = ckNameValueExpr.IndexOf('=');
                if (equalPos > 0) // is valid expression
                {
                    pair.key = ckNameValueExpr.Substring(0, equalPos);
                    pair.key = pair.key.Trim();
                    if (isValidCookieName(pair.key))
                    {
                        // only process while is valid cookie field
                        pair.value = ckNameValueExpr.Substring(equalPos + 1);
                        pair.value = pair.value.Trim();
                        parsedOK = true;
                    }
                    else
                    {
                        pair.key = "";
                        pair.value = "";
                        parsedOK = false;
                    }
                }
                else
                {
                    pair.key = "";
                    pair.value = "";
                    parsedOK = false;
                }
            }
            return parsedOK;
        }

        // parse cookie field expression
        public bool parseCookieField(string ckFieldExpr, out pairItem pair)
        {
            bool parsedOK = false;

            if (ckFieldExpr == "")
            {
                pair.key = "";
                pair.value = "";
                parsedOK = false;
            }
            else
            {
                ckFieldExpr = ckFieldExpr.Trim();

                //some specials: secure/httponly
                if (ckFieldExpr.ToLower() == "httponly")
                {
                    pair.key = "httponly";
                    //pair.value = "";
                    pair.value = "true";
                    parsedOK = true;
                }
                else if (ckFieldExpr.ToLower() == "secure")
                {
                    pair.key = "secure";
                    //pair.value = "";
                    pair.value = "true";
                    parsedOK = true;
                }
                else // normal cookie field
                {
                    int equalPos = ckFieldExpr.IndexOf('=');
                    if (equalPos > 0) // is valid expression
                    {
                        pair.key = ckFieldExpr.Substring(0, equalPos);
                        pair.key = pair.key.Trim();
                        if (isValidCookieField(pair.key))
                        {
                            // only process while is valid cookie field
                            pair.value = ckFieldExpr.Substring(equalPos + 1);
                            pair.value = pair.value.Trim();
                            parsedOK = true;
                        }
                        else
                        {
                            pair.key = "";
                            pair.value = "";
                            parsedOK = false;
                        }
                    }
                    else
                    {
                        pair.key = "";
                        pair.value = "";
                        parsedOK = false;
                    }
                }
            }

            return parsedOK;
        }//parseCookieField

        //parse single cookie string to a cookie
        //example: 
        //MSPShared=1; expires=Wed, 30-Dec-2037 16:00:00 GMT;domain=login.live.com;path=/;HTTPOnly= ;version=1
        //PPAuth=CkLXJYvPpNs3w!fIwMOFcraoSIAVYX3K!CdvZwQNwg3Y7gv74iqm9MqReX8XkJqtCFeMA6GYCWMb9m7CoIw!ID5gx3pOt8sOx1U5qQPv6ceuyiJYwmS86IW*l3BEaiyVCqFvju9BMll7!FHQeQholDsi0xqzCHuW!Qm2mrEtQPCv!qF3Sh9tZDjKcDZDI9iMByXc6R*J!JG4eCEUHIvEaxTQtftb4oc5uGpM!YyWT!r5jXIRyxqzsCULtWz4lsWHKzwrNlBRbF!A7ZXqXygCT8ek6luk7rarwLLJ!qaq2BvS; domain=login.live.com;secure= ;path=/;HTTPOnly= ;version=1
        public bool parseSingleCookie(string cookieStr, ref Cookie ck)
        {
            bool parsedOk = true;
            //Cookie ck = new Cookie();
            //string[] expressions = cookieStr.Split(";".ToCharArray(),StringSplitOptions.RemoveEmptyEntries);
            //refer: http://msdn.microsoft.com/en-us/library/b873y76a.aspx
            string[] expressions = cookieStr.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries);
            //get cookie name and value
            pairItem pair = new pairItem();
            if (parseCookieNameValue(expressions[0], out pair))
            {
                ck.Name = pair.key;
                ck.Value = pair.value;

                string[] fieldExpressions = getSubStrArr(expressions, 1, expressions.Length - 1);

                bool noDeisignateExpires = true;
                foreach (string eachExpression in fieldExpressions)
                {
                    //parse key and value
                    if (parseCookieField(eachExpression, out pair))
                    {
                        // add to cookie field if possible
                        bool addedOk = false;

                        addedOk = addFieldToCookie(ref ck, pair);

                        if (addedOk && string.Equals(pair.key, constStrExpires))
                        {
                            //is expires, and parse valid (added)
                            noDeisignateExpires = false;
                        }
                    }
                    else
                    {
                        // if any field fail, consider it is a abnormal cookie string, so quit with false
                        parsedOk = false;
                        break;
                    }
                }

                if (noDeisignateExpires)
                {
                    //for those not designate expires field
                    //set to max expires date -> let it not expires
                    ck.Expires = DateTime.MaxValue;
                }
            }
            else
            {
                parsedOk = false;
            }

            return parsedOk;
        }//parseSingleCookie


        // parse the Set-Cookie string (in http response header) to cookies
        // Note: auto omit to parse the abnormal cookie string
        // normal example for 'setCookieStr':
        // MSPOK= ; expires=Thu, 30-Oct-1980 16:00:00 GMT;domain=login.live.com;path=/;HTTPOnly= ;version=1,PPAuth=Cuyf3Vp2wolkjba!TOr*0v22UMYz36ReuiwxZZBc8umHJYPlRe4qupywVFFcIpbJyvYZ5ZDLBwV4zRM1UCjXC4tUwNuKvh21iz6gQb0Tu5K7Z62!TYGfowB9VQpGA8esZ7iCRucC7d5LiP3ZAv*j4Z3MOecaJwmPHx7!wDFdAMuQUZURhHuZWJiLzHP1j8ppchB2LExnlHO6IGAdZo1f0qzSWsZ2hq*yYP6sdy*FdTTKo336Q1B0i5q8jUg1Yv6c2FoBiNxhZSzxpuU0WrNHqSytutP2k4!wNc6eSnFDeouX; domain=login.live.com;secure= ;path=/;HTTPOnly= ;version=1,PPLState=1; domain=.live.com;path=/;version=1,MSPShared=1; expires=Wed, 30-Dec-2037 16:00:00 GMT;domain=login.live.com;path=/;HTTPOnly= ;version=1,MSPPre= ;domain=login.live.com;path=/;Expires=Thu, 30-Oct-1980 16:00:00 GMT,MSPCID= ; HTTPOnly= ; domain=login.live.com;path=/;Expires=Thu, 30-Oct-1980 16:00:00 GMT,RPSTAuth=EwDoARAnAAAUWkziSC7RbDJKS1VkhugDegv7L0eAAOfCAY2+pKwbV5zUlu3XmBbgrQ8EdakmdSqK9OIKfMzAbnU8fuwwEi+FKtdGSuz/FpCYutqiHWdftd0YF21US7+1bPxuLJ0MO+wVXB8GtjLKZaA0xCXlU5u01r+DOsxSVM777DmplaUc0Q4O1+Pi9gX9cyzQLAgRKmC/QtlbVNKDA2YAAAhIwqiXOVR/DDgBocoO/n0u48RFGh79X2Q+gO4Fl5GMc9Vtpa7SUJjZCCfoaitOmcxhEjlVmR/2ppdfJx3Ykek9OFzFd+ijtn7K629yrVFt3O9q5L0lWoxfDh5/daLK7lqJGKxn1KvOew0SHlOqxuuhYRW57ezFyicxkxSI3aLxYFiqHSu9pq+TlITqiflyfcAcw4MWpvHxm9on8Y1dM2R4X3sxuwrLQBpvNsG4oIaldTYIhMEnKhmxrP6ZswxzteNqIRvMEKsxiksBzQDDK/Cnm6QYBZNsPawc6aAedZioeYwaV3Z/i3tNrAUwYTqLXve8oG6ZNXL6WLT/irKq1EMilK6Cw8lT3G13WYdk/U9a6YZPJC8LdqR0vAHYpsu/xRF39/On+xDNPE4keIThJBptweOeWQfsMDwvgrYnMBKAMjpLZwE=; domain=.live.com;path=/;HTTPOnly= ;version=1,RPSTAuthTime=1328679636; domain=login.live.com;path=/;HTTPOnly= ;version=1,MSPAuth=2OlAAMHXtDIFOtpaK1afG2n*AAxdfCnCBlJFn*gCF8gLnCa1YgXEfyVh2m9nZuF*M7npEwb4a7Erpb*!nH5G285k7AswJOrsr*gY29AVAbsiz2UscjIGHkXiKrTvIzkV2M; domain=.live.com;path=/;HTTPOnly= ;version=1,MSPProf=23ci9sti6DZRrkDXfTt1b3lHhMdheWIcTZU2zdJS9!zCloHzMKwX30MfEAcCyOjVt*5WeFSK3l2ZahtEaK7HPFMm3INMs3r!JxI8odP9PYRHivop5ryohtMYzWZzj3gVVurcEr5Bg6eJJws7rXOggo3cR4FuKLtXwz*FVX0VWuB5*aJhRkCT1GZn*L5Pxzsm9X; domain=.live.com;path=/;HTTPOnly= ;version=1,MSNPPAuth=CiGSMoUOx4gej8yQkdFBvN!gvffvAhCPeWydcrAbcg!O2lrhVb4gruWSX5NZCBPsyrtZKmHLhRLTUUIxxPA7LIhqW5TCV*YcInlG2f5hBzwzHt!PORYbg79nCkvw65LKG399gRGtJ4wvXdNlhHNldkBK1jVXD4PoqO1Xzdcpv4sj68U6!oGrNK5KgRSMXXpLJmCeehUcsRW1NmInqQXpyanjykpYOcZy0vq!6PIxkj3gMaAvm!1vO58gXM9HX9dA0GloNmCDnRv4qWDV2XKqEKp!A7jiIMWTmHup1DZ!*YCtDX3nUVQ1zAYSMjHmmbMDxRJECz!1XEwm070w16Y40TzuKAJVugo!pyF!V2OaCsLjZ9tdGxGwEQRyi0oWc*Z7M0FBn8Fz0Dh4DhCzl1NnGun9kOYjK5itrF1Wh17sT!62ipv1vI8omeu0cVRww2Kv!qM*LFgwGlPOnNHj3*VulQOuaoliN4MUUxTA4owDubYZoKAwF*yp7Mg3zq5Ds2!l9Q$$; domain=.live.com;path=/;HTTPOnly= ;version=1,MH=MSFT; domain=.live.com;path=/;version=1,MHW=; expires=Thu, 30-Oct-1980 16:00:00 GMT;domain=.live.com;path=/;version=1,MHList=; expires=Thu, 30-Oct-1980 16:00:00 GMT;domain=.live.com;path=/;version=1,NAP=V=1.9&E=bea&C=zfjCKKBD0TqjZlWGgRTp__NiK08Lme_0XFaiKPaWJ0HDuMi2uCXafQ&W=1;domain=.live.com;path=/,ANON=A=DE389D4D076BF47BCAE4DC05FFFFFFFF&E=c44&W=1;domain=.live.com;path=/,MSPVis=$9;domain=login.live.com;path=/,pres=; expires=Thu, 30-Oct-1980 16:00:00 GMT;domain=.live.com;path=/;version=1,LOpt=0; domain=login.live.com;path=/;version=1,WLSSC=EgBnAQMAAAAEgAAACoAASfCD+8dUptvK4kvFO0gS3mVG28SPT3Jo9Pz2k65r9c9KrN4ISvidiEhxXaPLCSpkfa6fxH3FbdP9UmWAa9KnzKFJu/lQNkZC3rzzMcVUMjbLUpSVVyscJHcfSXmpGGgZK4ZCxPqXaIl9EZ0xWackE4k5zWugX7GR5m/RzakyVIzWAFwA1gD9vwYA7Vazl9QKMk/UCjJPECcAAAoQoAAAFwBjcmlmYW4yMDAzQGhvdG1haWwuY29tAE8AABZjcmlmYW4yMDAzQGhvdG1haWwuY29tAAAACUNOAAYyMTM1OTIAAAZlCAQCAAB3F21AAARDAAR0aWFuAAR3YW5nBMgAAUkAAAAAAAAAAAAAAaOKNpqLi/UAANQKMk/Uf0RPAAAAAAAAAAAAAAAADgA1OC4yNDAuMjM2LjE5AAUAAAAAAAAAAAAAAAABBAABAAABAAABAAAAAAAAAAA=; domain=.live.com;secure= ;path=/;HTTPOnly= ;version=1,MSPSoftVis=@72198325083833620@:@; domain=login.live.com;path=/;version=1
        // here now support parse the un-correct Set-Cookie:
        // MSPRequ=/;Version=1;version&lt=1328770452&id=250915&co=1; path=/;version=1,MSPVis=$9; Version=1;version=1$250915;domain=login.live.com;path=/,MSPSoftVis=@72198325083833620@:@; domain=login.live.com;path=/;version=1,MSPBack=1328770312; domain=login.live.com;path=/;version=1
        public CookieCollection parseSetCookie(string setCookieStr, string curDomain)
        {
            CookieCollection parsedCookies = new CookieCollection();

            // process for expires and Expires field, for it contains ','
            //refer: http://www.yaosansi.com/post/682.html
            // may contains expires or Expires, so following use xpires
            //string commaReplaced = Regex.Replace(setCookieStr, @"xpires=\w{3},\s\d{2}-\w{3}-\d{4}", new MatchEvaluator(_processExpireField));
            
            //special:
            //expires=Wed, 11-Sep-43 05:34:24 GMT;
            string commaReplaced = Regex.Replace(setCookieStr, @"xpires=\w{3},\s\d{2}-\w{3}-\d{2,4}", new MatchEvaluator(_processExpireField));
            string[] cookieStrArr = commaReplaced.Split(',');
            foreach (string cookieStr in cookieStrArr)
            {
                Cookie ck = new Cookie();
                // recover it back
                //string recoveredCookieStr = Regex.Replace(cookieStr, @"xpires=\w{3}" + replacedChar + @"\s\d{2}-\w{3}-\d{4}", new MatchEvaluator(_recoverExpireField));
                string recoveredCookieStr = Regex.Replace(cookieStr, @"xpires=\w{3}" + replacedChar + @"\s\d{2}-\w{3}-\d{2,4}", new MatchEvaluator(_recoverExpireField));
                if (parseSingleCookie(recoveredCookieStr, ref ck))
                {
                    if (needAddThisCookie(ck, curDomain))
                    {
                        parsedCookies.Add(ck);
                    }
                }
            }

            return parsedCookies;
        }//parseSetCookie

        // parse Set-Cookie string part into cookies
        // leave current domain to empty, means omit the parsed cookie, which is not set its domain value
        public CookieCollection parseSetCookie(string setCookieStr)
        {
            return parseSetCookie(setCookieStr, "");
        }

        //check whether a cookie is expired
        //if expired property is set, then just return it value
        //if not set, check whether is a session cookie, if is, then not expired
        //if expires is set, check its real time is expired or not
        public bool isCookieExpired(Cookie ck)
        {
            bool isExpired = false;

            if ((ck != null) && (ck.Name != ""))
            {
                if (ck.Expired)
                {
                    isExpired = true;
                }
                else
                {
                    DateTime initExpiresValue = (new Cookie()).Expires;
                    DateTime expires = ck.Expires;

                    if (expires.Equals(initExpiresValue))
                    {
                        // expires is not set, means this is session cookie, so here no expire
                    }
                    else
                    {
                        // has set expire value
                        if (DateTime.Now.Ticks > expires.Ticks)
                        {
                            isExpired = true;
                        }
                    }
                }
            }
            else
            {
                isExpired = true;
            }

            return isExpired;
        }

        //add a single cookie to cookies, if already exist, update its value
        public void addCookieToCookies(Cookie toAdd, ref CookieCollection cookies, bool overwriteDomain)
        {
            bool found = false;

            if (cookies.Count > 0)
            {
                foreach (Cookie originalCookie in cookies)
                {
                    if (originalCookie.Name == toAdd.Name)
                    {
                        // !!! for different domain, cookie is not same,
                        // so should not set the cookie value here while their domains is not same
                        // only if it explictly need overwrite domain
                        if ((originalCookie.Domain == toAdd.Domain) ||
                            ((originalCookie.Domain != toAdd.Domain) && overwriteDomain))
                        {
                            //here can not force convert CookieCollection to HttpCookieCollection,
                            //then use .remove to remove this cookie then add
                            // so no good way to copy all field value
                            originalCookie.Value = toAdd.Value;

                            originalCookie.Domain = toAdd.Domain;

                            originalCookie.Expires = toAdd.Expires;
                            originalCookie.Version = toAdd.Version;
                            originalCookie.Path = toAdd.Path;

                            //following fields seems should not change
                            //originalCookie.HttpOnly = toAdd.HttpOnly;
                            //originalCookie.Secure = toAdd.Secure;

                            found = true;
                            break;
                        }
                    }
                }
            }

            if (!found)
            {
                if (toAdd.Domain != "")
                {
                    // if add the null domain, will lead to follow req.CookieContainer.Add(cookies) failed !!!
                    cookies.Add(toAdd);
                }
            }

        }//addCookieToCookies

        //add singel cookie to cookies, default no overwrite domain
        public void addCookieToCookies(Cookie toAdd, ref CookieCollection cookies)
        {
            addCookieToCookies(toAdd, ref cookies, false);
        }

        //check whether the cookies contains the ckToCheck cookie
        //support:
        //ckTocheck is Cookie/string
        //cookies is Cookie/string/CookieCollection/string[]
        public bool isContainCookie(object ckToCheck, object cookies)
        {
            bool isContain = false;

            if ((ckToCheck != null) && (cookies != null))
            {
                string ckName = "";
                Type type = ckToCheck.GetType();

                //string typeStr = ckType.ToString();

                //if (ckType.FullName == "System.string")
                if (type.Name.ToLower() == "string")
                {
                    ckName = (string)ckToCheck;
                }
                else if (type.Name == "Cookie")
                {
                    ckName = ((Cookie)ckToCheck).Name;
                }

                if (ckName != "")
                {
                    type = cookies.GetType();

                    // is single Cookie
                    if (type.Name == "Cookie")
                    {
                        if (ckName == ((Cookie)cookies).Name)
                        {
                            isContain = true;
                        }
                    }
                    // is CookieCollection
                    else if (type.Name == "CookieCollection")
                    {
                        foreach (Cookie ck in (CookieCollection)cookies)
                        {
                            if (ckName == ck.Name)
                            {
                                isContain = true;
                                break;
                            }
                        }
                    }
                    // is single cookie name string
                    else if (type.Name.ToLower() == "string")
                    {
                        if (ckName == (string)cookies)
                        {
                            isContain = true;
                        }
                    }
                    // is cookie name string[]
                    else if (type.Name.ToLower() == "string[]")
                    {
                        foreach (string name in ((string[])cookies))
                        {
                            if (ckName == name)
                            {
                                isContain = true;
                                break;
                            }
                        }
                    }
                }
            }

            return isContain;
        }//isContainCookie

        // update cookiesToUpdate to localCookies
        // if omitUpdateCookies designated, then omit cookies of omitUpdateCookies in cookiesToUpdate
        public void updateLocalCookies(CookieCollection cookiesToUpdate, ref CookieCollection localCookies, object omitUpdateCookies)
        {
            if (cookiesToUpdate.Count > 0)
            {
                if (localCookies == null)
                {
                    localCookies = cookiesToUpdate;
                }
                else
                {
                    foreach (Cookie newCookie in cookiesToUpdate)
                    {
                        if (isContainCookie(newCookie, omitUpdateCookies))
                        {
                            // need omit process this
                        }
                        else
                        {
                            addCookieToCookies(newCookie, ref localCookies);
                        }
                    }
                }
            }
        }//updateLocalCookies

        //update cookiesToUpdate to localCookies
        public void updateLocalCookies(CookieCollection cookiesToUpdate, ref CookieCollection localCookies)
        {
            updateLocalCookies(cookiesToUpdate, ref localCookies, null);
        }
        
        //quote the input dict values
        //note: the return result for first para no '&'
        private string _quoteParas(Dictionary<string, string> paras, bool spaceToPercent20 = true)
        {
            string quotedParas = "";
            bool isFirst = true;
            string val = "";
            foreach (string para in paras.Keys)
            {
                if (paras.TryGetValue(para, out val))
                {
                    string encodedVal = "";
                    if (spaceToPercent20)
                    {
                        //encodedVal = HttpUtility.UrlPathEncode(val);
                        //encodedVal = Uri.EscapeDataString(val);
                        //encodedVal = Uri.EscapeUriString(val);
                        encodedVal = HttpUtility.UrlEncode(val).Replace("+", "%20");
                    }
                    else
                    {
                        encodedVal = HttpUtility.UrlEncode(val); //space to +
                    }

                    if (isFirst)
                    {
                        isFirst = false;
                        quotedParas += para + "=" + encodedVal;
                    }
                    else
                    {
                        quotedParas += "&" + para + "=" + encodedVal;
                    }
                }
                else
                {
                    break;
                }
            }

            return quotedParas;
        }


        /* get url's response */
        private HttpWebResponse _getUrlResponse(string url,
                                        Dictionary<string, string> headerDict = defHeaderDict,
                                        Dictionary<string, string> postDict = defPostDict,
                                        int timeout = defTimeout,
                                        string postDataStr = defPostDataStr,
                                        int readWriteTimeout = defReadWriteTimeout)
        {
            //CookieCollection parsedCookies;

            HttpWebResponse resp = null;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);

            req.AllowAutoRedirect = true;
            req.Accept = "*/*";

            //req.ContentType = "text/plain";

            //const string gAcceptLanguage = "en-US"; // zh-CN/en-US
            //req.Headers["Accept-Language"] = gAcceptLanguage;

            req.KeepAlive = true;

            req.UserAgent = gUserAgent;

            req.Headers["Accept-Encoding"] = "gzip, deflate";
            //req.AutomaticDecompression = DecompressionMethods.GZip;
            req.AutomaticDecompression = DecompressionMethods.GZip | DecompressionMethods.Deflate;

            req.Proxy = gProxy;

            if (timeout > 0)
            {
                req.Timeout = timeout;
            }

            if (readWriteTimeout > 0)
            {
                //default ReadWriteTimeout is 300000=300 seconds = 5 minutes !!!
                //too long, so here change to 300000 = 30 seconds
                //for support TimeOut for later StreamReader's ReadToEnd
                req.ReadWriteTimeout = readWriteTimeout;
            }

            if (gCurCookies != null)
            {
                req.CookieContainer = new CookieContainer();
                req.CookieContainer.PerDomainCapacity = 40; // following will exceed max default 20 cookie per domain
                req.CookieContainer.Add(gCurCookies);
            }

            if ((headerDict != null) && (headerDict.Count > 0))
            {
                foreach (string header in headerDict.Keys)
                {
                    string headerValue = "";
                    if (headerDict.TryGetValue(header, out headerValue))
                    {
                        string lowecaseHeader = header.ToLower();
                        // following are allow the caller overwrite the default header setting
                        if (lowecaseHeader == "referer")
                        {
                            req.Referer = headerValue;
                        }
                        else if (
                                (lowecaseHeader == "allow-autoredirect") ||
                                (lowecaseHeader == "allowautoredirect") ||
                                (lowecaseHeader == "allow autoredirect")
                                )
                        {
                            bool isAllow = false;
                            if (bool.TryParse(headerValue, out isAllow))
                            {
                                req.AllowAutoRedirect = isAllow;
                            }
                        }
                        else if (lowecaseHeader == "accept")
                        {
                            req.Accept = headerValue;
                        }
                        else if (
                                (lowecaseHeader == "keep-alive") ||
                                (lowecaseHeader == "keepalive") ||
                                (lowecaseHeader == "keep alive")
                                )
                        {
                            bool isKeepAlive = false;
                            if (bool.TryParse(headerValue, out isKeepAlive))
                            {
                                req.KeepAlive = isKeepAlive;
                            }
                        }
                        else if (
                                (lowecaseHeader == "accept-language") ||
                                (lowecaseHeader == "acceptlanguage") ||
                                (lowecaseHeader == "accept language")
                                )
                        {
                            req.Headers["Accept-Language"] = headerValue;
                        }
                        else if (
                                (lowecaseHeader == "user-agent") ||
                                (lowecaseHeader == "useragent") ||
                                (lowecaseHeader == "user agent")
                                )
                        {
                            req.UserAgent = headerValue;
                        }
                        else if (
                                (lowecaseHeader == "content-type") ||
                                (lowecaseHeader == "contenttype") ||
                                (lowecaseHeader == "content type")
                                )
                        {
                            req.ContentType = headerValue;
                        }
                        else
                        {
                            req.Headers[header] = headerValue;
                        }
                    }
                    else
                    {
                        break;
                    }
                }
            }

            if (((postDict != null) && (postDict.Count > 0)) || (!string.IsNullOrEmpty(postDataStr)))
            {
                req.Method = "POST";
                if (req.ContentType == null)
                {
                    req.ContentType = "application/x-www-form-urlencoded";
                }

                if ((postDict != null) && (postDict.Count > 0))
                {
                    postDataStr = _quoteParas(postDict);
                }

                //byte[] postBytes = Encoding.GetEncoding("utf-8").GetBytes(postData);
                byte[] postBytes = Encoding.UTF8.GetBytes(postDataStr);
                req.ContentLength = postBytes.Length;

                try
                {
                    Stream postDataStream = req.GetRequestStream();
                    postDataStream.Write(postBytes, 0, postBytes.Length);
                    postDataStream.Close();
                }
                catch (WebException webEx)
                {
                    //for prev has set ReadWriteTimeout
                    //so here also may timeout
                    if (webEx.Status == WebExceptionStatus.Timeout)
                    {
                        req = null;
                    }
                }
            }
            else
            {
                req.Method = "GET";
            }

            if (req != null)
            {
                //may timeout, has fixed in:
                //http://www.crifan.com/fixed_problem_sometime_httpwebrequest_getresponse_timeout/
                try
                {
                    resp = (HttpWebResponse)req.GetResponse();
                    
                    //type1: use dotnet parse cookies
                    //updateLocalCookies(resp.Cookies, ref gCurCookies);

                    //type2: use crifanLib.cs functions to parse cookie
                    //update latest cookies
                    string curDomain = extractDomain(url);
                    CookieCollection parsedCookies = parseSetCookie(resp.Headers["Set-Cookie"], curDomain);
                    updateLocalCookies(parsedCookies, ref gCurCookies);
                }
                catch (WebException webEx)
                {
                    if (webEx.Status == WebExceptionStatus.Timeout)
                    {
                        resp = null;
                    }
                }
            }

            return resp;
        }


        // valid charset:"GB18030"/"UTF-8", invliad:"UTF8"
        public string getUrlRespHtml(string url,
                                        Dictionary<string, string> headerDict = defHeaderDict,
                                        string charset = defCharset,
                                        Dictionary<string, string> postDict = defPostDict,
                                        int timeout = defTimeout,
                                        string postDataStr = defPostDataStr,
                                        int readWriteTimeout = defReadWriteTimeout)
        {
            string respHtml = "";

            //HttpWebResponse resp = getUrlResponse(url, headerDict, postDict, timeout, postDataStr, readWriteTimeout);
            HttpWebResponse resp = _getUrlResponse(url, headerDict, postDict, timeout, postDataStr, readWriteTimeout);

            //long realRespLen = resp.ContentLength;
            if (resp != null)
            {
                StreamReader sr;
                Stream respStream = resp.GetResponseStream();
                if (!string.IsNullOrEmpty(charset))
                {
                    Encoding htmlEncoding = Encoding.GetEncoding(charset);
                    sr = new StreamReader(respStream, htmlEncoding);
                }
                else
                {
                    sr = new StreamReader(respStream);
                }

                try
                {
                    respHtml = sr.ReadToEnd();

                    //while (!sr.EndOfStream)
                    //{
                    //    respHtml = respHtml + sr.ReadLine();
                    //}

                    //string curLine = "";
                    //while ((curLine = sr.ReadLine()) != null)
                    //{
                    //    respHtml = respHtml + curLine;
                    //}

                    ////http://msdn.microsoft.com/zh-cn/library/system.io.streamreader.peek.aspx
                    //while (sr.Peek() > -1) //while not error or not reach end of stream
                    //{
                    //    respHtml = respHtml + sr.ReadLine();
                    //}

                    //respStream.Close();
                    //sr.Close();
                    //resp.Close();
                }
                catch (Exception ex)
                {
                    //【未解决】C#中StreamReader中遇到异常：未处理ObjectDisposedException,无法访问已关闭的流
                    //http://www.crifan.com/csharp_streamreader_unhandled_exception_objectdisposedexception_cannot_access_closed_stream
                    //System.ObjectDisposedException
                    respHtml = "";
                }
                finally
                {
                    if (respStream != null)
                    {
                        respStream.Close();
                    }
                    if (sr != null)
                    {
                        sr.Close();
                    }
                    if (resp != null)
                    {
                        resp.Close();
                    }
                }
            }

            return respHtml;
        }

        /******************************************************************************
        Demo emulate login baidu related functions
        *******************************************************************************/

        private void btnGetBaiduid_Click(object sender, EventArgs e)
        {
            //http://www.baidu.com/
            string baiduMainUrl = txbBaiduMainUrl.Text;
            HttpWebResponse resp = _getUrlResponse(baiduMainUrl);
            //inside _getUrlResponse will process and get gCurCookies           
            txbGotBaiduid.Text = "";
            //foreach (Cookie ck in resp.Cookies)
            foreach (Cookie ck in gCurCookies)
            {
                txbGotBaiduid.Text += "[" + ck.Name + "]=" + ck.Value + Environment.NewLine;
                if (ck.Name == "BAIDUID")
                {
                    gotCookieBaiduid = true;
                }
            }

            if (gotCookieBaiduid)
            {
                //already got andd store cookies before, inside _getUrlResponse
            }
            else 
            {
                MessageBox.Show("错误：没有找到cookie BAIDUID ！");
            }
        }

        private void btnGetToken_Click(object sender, EventArgs e)
        {
            if (gotCookieBaiduid)
            {
                string getapiUrl = "https://passport.baidu.com/v2/api/?getapi&class=login&tpl=mn&tangram=true";

                //https://passport.baidu.com/v2/api/?getapi&tpl=mn&apiver=v3&tt=1378868748011&class=login&logintype=dialogLogin&callback=bd__cbs__lm47sm
                //string getapiUrl = "https://passport.baidu.com/v2/api/?getapi&class=login&tpl=mn&apiver=v3";
                //string getapiUrl = "https://passport.baidu.com/v2/api/?getapi&class=login&tpl=mn&apiver=v3&logintype=dialogLogin";

                string respHtml = getUrlRespHtml(getapiUrl);

                //bdPass.api.params.login_token='5ab690978812b0e7fbbe1bfc267b90b3';

                //when use .NET 4.0, return following html:

                //var bdPass=bdPass||{};
                //bdPass.api=bdPass.api||{};
                //bdPass.api.params=bdPass.api.params||{};
                //bdPass.api.params.login_token='the fisrt two args should be string type:0,1!';
                //    bdPass.api.params.login_tpl='mn';

                //            document.write('<script type="text/javascript" charset="UTF-8" src="https://passport.baidu.com/js/v2ApiUsedTangramFunctions.js?v=20130905"></script>');
                //        document.write('<script type="text/javascript" charset="UTF-8" src="https://passport.baidu.com/js/pass_api_login.js?v=20130905"></script>');

                string tokenValP = @"bdPass\.api\.params\.login_token='(?<tokenVal>\w+)';";
                Match foundTokenVal = (new Regex(tokenValP)).Match(respHtml);
                if (foundTokenVal.Success)
                {
                    //extracted the token value
                    txbExtractedTokenVal.Text = foundTokenVal.Groups["tokenVal"].Value;
                    extractTokenValueOK = true;
                }
                else
                {
                    txbExtractedTokenVal.Text = "错误：没有找到token的值！";
                }

            }
            else 
            {
                MessageBox.Show("错误：之前没有正确获得Cookie：BAIDUID ！");
            }
        }

        private void btnEmulateLoginBaidu_Click(object sender, EventArgs e)
        {
            if (gotCookieBaiduid && extractTokenValueOK)
            {
                string staticpage = "http://www.baidu.com/cache/user/html/jump.html";
                
                //init post dict info
                Dictionary<string, string> postDict = new Dictionary<string, string>();
                //postDict.Add("ppui_logintime", "");
                postDict.Add("charset", "utf-8");
                //postDict.Add("codestring", "");
                postDict.Add("token", txbExtractedTokenVal.Text);
                postDict.Add("isPhone", "false");
                postDict.Add("index", "0");
                //postDict.Add("u", "");
                //postDict.Add("safeflg", "0");
                postDict.Add("staticpage", staticpage);
                postDict.Add("loginType", "1");
                postDict.Add("tpl", "mn");
                postDict.Add("callback", "parent.bdPass.api.login._postCallback");
                postDict.Add("username", txbBaiduUsername.Text);
                postDict.Add("password", txbBaiduPassword.Text);
                //postDict.Add("verifycode", "");
                postDict.Add("mem_pass", "on");

                string baiduMainLoginUrl = "https://passport.baidu.com/v2/api/?login";
                string loginBaiduRespHtml = getUrlRespHtml(baiduMainLoginUrl, postDict:postDict);

                //check whether got all expected cookies
                Dictionary<string, bool> cookieCheckDict = new Dictionary<string, bool>();
                string[] cookiesNameList = {"BDUSS", "PTOKEN", "STOKEN", "SAVEUSERID"};
                foreach (String cookieToCheck in cookiesNameList)
                {
                    cookieCheckDict.Add(cookieToCheck, false); 
                }

                foreach (Cookie singleCookie in gCurCookies)
                {
                    if (cookieCheckDict.ContainsKey(singleCookie.Name))
                    {
                        cookieCheckDict[singleCookie.Name] = true;
                    }
                }

                bool allCookiesFound = true;
                foreach (bool foundCurCookie in cookieCheckDict.Values)
                {
                    allCookiesFound = allCookiesFound && foundCurCookie; 
                }


                loginBaiduOk = allCookiesFound;
                if (loginBaiduOk)
                {
                    txbEmulateLoginResult.Text = "成功模拟登陆百度首页！";
                }
                else
                {
                    txbEmulateLoginResult.Text = "模拟登陆百度首页 失败！";
                    txbEmulateLoginResult.Text += Environment.NewLine + "所返回的HTML源码为：";
                    txbEmulateLoginResult.Text += Environment.NewLine + loginBaiduRespHtml;
                }
            }
            else
            {
                MessageBox.Show("错误：没有正确获得Cookie BAIDUID 和/或 没有正确提取出token值！");
            }
        }

        private void lklEmulateLoginTutorialUrl_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            string emulateLoginTutorialUrl = "http://www.crifan.com/emulate_login_website_using_csharp";
            System.Diagnostics.Process.Start(emulateLoginTutorialUrl);
        }

        private void btnClearAll_Click(object sender, EventArgs e)
        {
            gCurCookies = new CookieCollection();
            gotCookieBaiduid = false;
            extractTokenValueOK = false;
            loginBaiduOk = false;

            txbGotBaiduid.Text = "";
            txbExtractedTokenVal.Text = "";

            txbBaiduUsername.Text = "";
            txbBaiduPassword.Text = "";
            txbEmulateLoginResult.Text = "";
        }
    }
}
